package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ParallelStatusFluentImpl<A extends ParallelStatusFluent<A>> extends BaseFluent<A> implements ParallelStatusFluent<A>{
  public ParallelStatusFluentImpl() {
  }
  public ParallelStatusFluentImpl(ParallelStatus instance) {
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withBranchStatuses(instance.getBranchStatuses()); 
    this.withConditions(instance.getConditions()); 
    this.withIngressChannelStatus(instance.getIngressChannelStatus()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<ParallelBranchStatusBuilder> branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private ParallelChannelStatusBuilder ingressChannelStatus;
  private Long observedGeneration;
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewAddress(String url) {
    return (A)withAddress(new Addressable(url));
  }
  public ParallelStatusFluent.AddressNested<A> withNewAddress() {
    return new ParallelStatusFluentImpl.AddressNestedImpl();
  }
  public ParallelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
    return new ParallelStatusFluentImpl.AddressNestedImpl(item);
  }
  public ParallelStatusFluent.AddressNested<A> editAddress() {
    return withNewAddressLike(getAddress());
  }
  public ParallelStatusFluent.AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public ParallelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToBranchStatuses(Integer index,ParallelBranchStatus item) {
    if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
    ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(index >= 0 ? index : _visitables.get("branchStatuses").size(), builder);this.branchStatuses.add(index >= 0 ? index : branchStatuses.size(), builder); return (A)this;
  }
  public A setToBranchStatuses(Integer index,ParallelBranchStatus item) {
    if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
    ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("branchStatuses").size()) { _visitables.get("branchStatuses").add(builder); } else { _visitables.get("branchStatuses").set(index, builder);}
    if (index < 0 || index >= branchStatuses.size()) { branchStatuses.add(builder); } else { branchStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToBranchStatuses(io.fabric8.knative.flows.v1.ParallelBranchStatus... items) {
    if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
    for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(builder);this.branchStatuses.add(builder);} return (A)this;
  }
  public A addAllToBranchStatuses(Collection<ParallelBranchStatus> items) {
    if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
    for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(builder);this.branchStatuses.add(builder);} return (A)this;
  }
  public A removeFromBranchStatuses(io.fabric8.knative.flows.v1.ParallelBranchStatus... items) {
    for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").remove(builder);if (this.branchStatuses != null) {this.branchStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromBranchStatuses(Collection<ParallelBranchStatus> items) {
    for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").remove(builder);if (this.branchStatuses != null) {this.branchStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBranchStatuses(Predicate<ParallelBranchStatusBuilder> predicate) {
    if (branchStatuses == null) return (A) this;
    final Iterator<ParallelBranchStatusBuilder> each = branchStatuses.iterator();
    final List visitables = _visitables.get("branchStatuses");
    while (each.hasNext()) {
      ParallelBranchStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBranchStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParallelBranchStatus> getBranchStatuses() {
    return branchStatuses != null ? build(branchStatuses) : null;
  }
  public List<ParallelBranchStatus> buildBranchStatuses() {
    return branchStatuses != null ? build(branchStatuses) : null;
  }
  public ParallelBranchStatus buildBranchStatus(Integer index) {
    return this.branchStatuses.get(index).build();
  }
  public ParallelBranchStatus buildFirstBranchStatus() {
    return this.branchStatuses.get(0).build();
  }
  public ParallelBranchStatus buildLastBranchStatus() {
    return this.branchStatuses.get(branchStatuses.size() - 1).build();
  }
  public ParallelBranchStatus buildMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
    for (ParallelBranchStatusBuilder item: branchStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
    for (ParallelBranchStatusBuilder item: branchStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBranchStatuses(List<ParallelBranchStatus> branchStatuses) {
    if (this.branchStatuses != null) { _visitables.get("branchStatuses").removeAll(this.branchStatuses);}
    if (branchStatuses != null) {this.branchStatuses = new ArrayList(); for (ParallelBranchStatus item : branchStatuses){this.addToBranchStatuses(item);}} else { this.branchStatuses = null;} return (A) this;
  }
  public A withBranchStatuses(io.fabric8.knative.flows.v1.ParallelBranchStatus... branchStatuses) {
    if (this.branchStatuses != null) {this.branchStatuses.clear();}
    if (branchStatuses != null) {for (ParallelBranchStatus item :branchStatuses){ this.addToBranchStatuses(item);}} return (A) this;
  }
  public Boolean hasBranchStatuses() {
    return branchStatuses != null && !branchStatuses.isEmpty();
  }
  public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatus() {
    return new ParallelStatusFluentImpl.BranchStatusesNestedImpl();
  }
  public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatusLike(ParallelBranchStatus item) {
    return new ParallelStatusFluentImpl.BranchStatusesNestedImpl(-1, item);
  }
  public ParallelStatusFluent.BranchStatusesNested<A> setNewBranchStatusLike(Integer index,ParallelBranchStatus item) {
    return new ParallelStatusFluentImpl.BranchStatusesNestedImpl(index, item);
  }
  public ParallelStatusFluent.BranchStatusesNested<A> editBranchStatus(Integer index) {
    if (branchStatuses.size() <= index) throw new RuntimeException("Can't edit branchStatuses. Index exceeds size.");
    return setNewBranchStatusLike(index, buildBranchStatus(index));
  }
  public ParallelStatusFluent.BranchStatusesNested<A> editFirstBranchStatus() {
    if (branchStatuses.size() == 0) throw new RuntimeException("Can't edit first branchStatuses. The list is empty.");
    return setNewBranchStatusLike(0, buildBranchStatus(0));
  }
  public ParallelStatusFluent.BranchStatusesNested<A> editLastBranchStatus() {
    int index = branchStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last branchStatuses. The list is empty.");
    return setNewBranchStatusLike(index, buildBranchStatus(index));
  }
  public ParallelStatusFluent.BranchStatusesNested<A> editMatchingBranchStatus(Predicate<ParallelBranchStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<branchStatuses.size();i++) { 
    if (predicate.test(branchStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching branchStatuses. No match found.");
    return setNewBranchStatusLike(index, buildBranchStatus(index));
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ParallelStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ParallelStatusFluentImpl.ConditionsNestedImpl();
  }
  public ParallelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ParallelStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ParallelStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new ParallelStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ParallelStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ParallelStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ParallelStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ParallelStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildIngressChannelStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ParallelChannelStatus getIngressChannelStatus() {
    return this.ingressChannelStatus!=null ?this.ingressChannelStatus.build():null;
  }
  public ParallelChannelStatus buildIngressChannelStatus() {
    return this.ingressChannelStatus!=null ?this.ingressChannelStatus.build():null;
  }
  public A withIngressChannelStatus(ParallelChannelStatus ingressChannelStatus) {
    _visitables.get("ingressChannelStatus").remove(this.ingressChannelStatus);
    if (ingressChannelStatus!=null){ this.ingressChannelStatus= new ParallelChannelStatusBuilder(ingressChannelStatus); _visitables.get("ingressChannelStatus").add(this.ingressChannelStatus);} else { this.ingressChannelStatus = null; _visitables.get("ingressChannelStatus").remove(this.ingressChannelStatus); } return (A) this;
  }
  public Boolean hasIngressChannelStatus() {
    return this.ingressChannelStatus != null;
  }
  public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatus() {
    return new ParallelStatusFluentImpl.IngressChannelStatusNestedImpl();
  }
  public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatusLike(ParallelChannelStatus item) {
    return new ParallelStatusFluentImpl.IngressChannelStatusNestedImpl(item);
  }
  public ParallelStatusFluent.IngressChannelStatusNested<A> editIngressChannelStatus() {
    return withNewIngressChannelStatusLike(getIngressChannelStatus());
  }
  public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatus() {
    return withNewIngressChannelStatusLike(getIngressChannelStatus() != null ? getIngressChannelStatus(): new ParallelChannelStatusBuilder().build());
  }
  public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatusLike(ParallelChannelStatus item) {
    return withNewIngressChannelStatusLike(getIngressChannelStatus() != null ? getIngressChannelStatus(): item);
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParallelStatusFluentImpl that = (ParallelStatusFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (branchStatuses != null ? !branchStatuses.equals(that.branchStatuses) :that.branchStatuses != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (ingressChannelStatus != null ? !ingressChannelStatus.equals(that.ingressChannelStatus) :that.ingressChannelStatus != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  branchStatuses,  conditions,  ingressChannelStatus,  observedGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (branchStatuses != null && !branchStatuses.isEmpty()) { sb.append("branchStatuses:"); sb.append(branchStatuses + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (ingressChannelStatus != null) { sb.append("ingressChannelStatus:"); sb.append(ingressChannelStatus + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration); }
    sb.append("}");
    return sb.toString();
  }
  class AddressNestedImpl<N> extends AddressableFluentImpl<ParallelStatusFluent.AddressNested<N>> implements ParallelStatusFluent.AddressNested<N>,Nested<N>{
    AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) ParallelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class BranchStatusesNestedImpl<N> extends ParallelBranchStatusFluentImpl<ParallelStatusFluent.BranchStatusesNested<N>> implements ParallelStatusFluent.BranchStatusesNested<N>,Nested<N>{
    BranchStatusesNestedImpl(Integer index,ParallelBranchStatus item) {
      this.index = index;
      this.builder = new ParallelBranchStatusBuilder(this, item);
    }
    BranchStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ParallelBranchStatusBuilder(this);
    }
    ParallelBranchStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ParallelStatusFluentImpl.this.setToBranchStatuses(index,builder.build());
    }
    public N endBranchStatus() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<ParallelStatusFluent.ConditionsNested<N>> implements ParallelStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ParallelStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class IngressChannelStatusNestedImpl<N> extends ParallelChannelStatusFluentImpl<ParallelStatusFluent.IngressChannelStatusNested<N>> implements ParallelStatusFluent.IngressChannelStatusNested<N>,Nested<N>{
    IngressChannelStatusNestedImpl(ParallelChannelStatus item) {
      this.builder = new ParallelChannelStatusBuilder(this, item);
    }
    IngressChannelStatusNestedImpl() {
      this.builder = new ParallelChannelStatusBuilder(this);
    }
    ParallelChannelStatusBuilder builder;
    public N and() {
      return (N) ParallelStatusFluentImpl.this.withIngressChannelStatus(builder.build());
    }
    public N endIngressChannelStatus() {
      return and();
    }
    
  }
  
}