package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabSourceBuilder extends GitLabSourceFluentImpl<GitLabSourceBuilder> implements VisitableBuilder<GitLabSource,GitLabSourceBuilder>{
  public GitLabSourceBuilder() {
    this(false);
  }
  public GitLabSourceBuilder(Boolean validationEnabled) {
    this(new GitLabSource(), validationEnabled);
  }
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabSource(), validationEnabled);
  }
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,GitLabSource instance) {
    this(fluent, instance, false);
  }
  public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,GitLabSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitLabSourceBuilder(GitLabSource instance) {
    this(instance,false);
  }
  public GitLabSourceBuilder(GitLabSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  GitLabSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabSource build() {
    GitLabSource buildable = new GitLabSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}