package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubSourceStatusBuilder extends GitHubSourceStatusFluentImpl<GitHubSourceStatusBuilder> implements VisitableBuilder<GitHubSourceStatus,GitHubSourceStatusBuilder>{
  public GitHubSourceStatusBuilder() {
    this(false);
  }
  public GitHubSourceStatusBuilder(Boolean validationEnabled) {
    this(new GitHubSourceStatus(), validationEnabled);
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubSourceStatus(), validationEnabled);
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,GitHubSourceStatus instance) {
    this(fluent, instance, false);
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatusFluent<?> fluent,GitHubSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withCeAttributes(instance.getCeAttributes()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSinkUri(instance.getSinkUri()); 
    fluent.withWebhookIDKey(instance.getWebhookIDKey()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatus instance) {
    this(instance,false);
  }
  public GitHubSourceStatusBuilder(GitHubSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCeAttributes(instance.getCeAttributes()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSinkUri(instance.getSinkUri()); 
    this.withWebhookIDKey(instance.getWebhookIDKey()); 
    this.validationEnabled = validationEnabled; 
  }
  GitHubSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubSourceStatus build() {
    GitHubSourceStatus buildable = new GitHubSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri(),fluent.getWebhookIDKey());
    return buildable;
  }
  
}