package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WorkloadGroupListFluentImpl<A extends WorkloadGroupListFluent<A>> extends BaseFluent<A> implements WorkloadGroupListFluent<A>{
  public WorkloadGroupListFluentImpl() {
  }
  public WorkloadGroupListFluentImpl(WorkloadGroupList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<WorkloadGroupBuilder> items = new ArrayList<WorkloadGroupBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,WorkloadGroup item) {
    if (this.items == null) {this.items = new ArrayList<WorkloadGroupBuilder>();}
    WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,WorkloadGroup item) {
    if (this.items == null) {this.items = new ArrayList<WorkloadGroupBuilder>();}
    WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.istio.api.networking.v1alpha3.WorkloadGroup... items) {
    if (this.items == null) {this.items = new ArrayList<WorkloadGroupBuilder>();}
    for (WorkloadGroup item : items) {WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<WorkloadGroup> items) {
    if (this.items == null) {this.items = new ArrayList<WorkloadGroupBuilder>();}
    for (WorkloadGroup item : items) {WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.istio.api.networking.v1alpha3.WorkloadGroup... items) {
    for (WorkloadGroup item : items) {WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<WorkloadGroup> items) {
    for (WorkloadGroup item : items) {WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<WorkloadGroupBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<WorkloadGroupBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      WorkloadGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkloadGroup> getItems() {
    return items != null ? build(items) : null;
  }
  public List<WorkloadGroup> buildItems() {
    return items != null ? build(items) : null;
  }
  public WorkloadGroup buildItem(int index) {
    return this.items.get(index).build();
  }
  public WorkloadGroup buildFirstItem() {
    return this.items.get(0).build();
  }
  public WorkloadGroup buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public WorkloadGroup buildMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
    for (WorkloadGroupBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
    for (WorkloadGroupBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<WorkloadGroup> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (WorkloadGroup item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.istio.api.networking.v1alpha3.WorkloadGroup... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (WorkloadGroup item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> addNewItem() {
    return new WorkloadGroupListFluentImpl.ItemsNestedImpl();
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> addNewItemLike(WorkloadGroup item) {
    return new WorkloadGroupListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> setNewItemLike(int index,WorkloadGroup item) {
    return new WorkloadGroupListFluentImpl.ItemsNestedImpl(index, item);
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public WorkloadGroupListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkloadGroupListFluentImpl that = (WorkloadGroupListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends WorkloadGroupFluentImpl<WorkloadGroupListFluentImpl.ItemsNested<N>> implements WorkloadGroupListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,WorkloadGroup item) {
      this.index = index;
      this.builder = new WorkloadGroupBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new WorkloadGroupBuilder(this);
    }
    WorkloadGroupBuilder builder;
    int index;
    public N and() {
      return (N) WorkloadGroupListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}