package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarBuilder extends SidecarFluentImpl<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder>{
  public SidecarBuilder() {
    this(false);
  }
  public SidecarBuilder(Boolean validationEnabled) {
    this(new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
    this(fluent, instance, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SidecarBuilder(Sidecar instance) {
    this(instance,false);
  }
  public SidecarBuilder(Sidecar instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  SidecarFluent<?> fluent;
  Boolean validationEnabled;
  public Sidecar build() {
    Sidecar buildable = new Sidecar(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}