package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEntrySpecBuilder extends ServiceEntrySpecFluentImpl<ServiceEntrySpecBuilder> implements VisitableBuilder<ServiceEntrySpec,ServiceEntrySpecBuilder>{
  public ServiceEntrySpecBuilder() {
    this(false);
  }
  public ServiceEntrySpecBuilder(Boolean validationEnabled) {
    this(new ServiceEntrySpec(), validationEnabled);
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceEntrySpec(), validationEnabled);
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance) {
    this(fluent, instance, false);
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withExportTo(instance.getExportTo());
      fluent.withHosts(instance.getHosts());
      fluent.withLocation(instance.getLocation());
      fluent.withPorts(instance.getPorts());
      fluent.withResolution(instance.getResolution());
      fluent.withSubjectAltNames(instance.getSubjectAltNames());
      fluent.withWorkloadSelector(instance.getWorkloadSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpec instance) {
    this(instance,false);
  }
  public ServiceEntrySpecBuilder(ServiceEntrySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withEndpoints(instance.getEndpoints());
      this.withExportTo(instance.getExportTo());
      this.withHosts(instance.getHosts());
      this.withLocation(instance.getLocation());
      this.withPorts(instance.getPorts());
      this.withResolution(instance.getResolution());
      this.withSubjectAltNames(instance.getSubjectAltNames());
      this.withWorkloadSelector(instance.getWorkloadSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceEntrySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceEntrySpec build() {
    ServiceEntrySpec buildable = new ServiceEntrySpec(fluent.getAddresses(),fluent.getEndpoints(),fluent.getExportTo(),fluent.getHosts(),fluent.getLocation(),fluent.getPorts(),fluent.getResolution(),fluent.getSubjectAltNames(),fluent.getWorkloadSelector());
    return buildable;
  }
  
}