package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerTLSSettingsBuilder extends ServerTLSSettingsFluentImpl<ServerTLSSettingsBuilder> implements VisitableBuilder<ServerTLSSettings,ServerTLSSettingsBuilder>{
  public ServerTLSSettingsBuilder() {
    this(false);
  }
  public ServerTLSSettingsBuilder(Boolean validationEnabled) {
    this(new ServerTLSSettings(), validationEnabled);
  }
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServerTLSSettings(), validationEnabled);
  }
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent,ServerTLSSettings instance) {
    this(fluent, instance, false);
  }
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent,ServerTLSSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCaCertificates(instance.getCaCertificates());
      fluent.withCipherSuites(instance.getCipherSuites());
      fluent.withCredentialName(instance.getCredentialName());
      fluent.withHttpsRedirect(instance.getHttpsRedirect());
      fluent.withMaxProtocolVersion(instance.getMaxProtocolVersion());
      fluent.withMinProtocolVersion(instance.getMinProtocolVersion());
      fluent.withMode(instance.getMode());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withServerCertificate(instance.getServerCertificate());
      fluent.withSubjectAltNames(instance.getSubjectAltNames());
      fluent.withVerifyCertificateHash(instance.getVerifyCertificateHash());
      fluent.withVerifyCertificateSpki(instance.getVerifyCertificateSpki());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerTLSSettingsBuilder(ServerTLSSettings instance) {
    this(instance,false);
  }
  public ServerTLSSettingsBuilder(ServerTLSSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCaCertificates(instance.getCaCertificates());
      this.withCipherSuites(instance.getCipherSuites());
      this.withCredentialName(instance.getCredentialName());
      this.withHttpsRedirect(instance.getHttpsRedirect());
      this.withMaxProtocolVersion(instance.getMaxProtocolVersion());
      this.withMinProtocolVersion(instance.getMinProtocolVersion());
      this.withMode(instance.getMode());
      this.withPrivateKey(instance.getPrivateKey());
      this.withServerCertificate(instance.getServerCertificate());
      this.withSubjectAltNames(instance.getSubjectAltNames());
      this.withVerifyCertificateHash(instance.getVerifyCertificateHash());
      this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerTLSSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ServerTLSSettings build() {
    ServerTLSSettings buildable = new ServerTLSSettings(fluent.getCaCertificates(),fluent.getCipherSuites(),fluent.getCredentialName(),fluent.getHttpsRedirect(),fluent.getMaxProtocolVersion(),fluent.getMinProtocolVersion(),fluent.getMode(),fluent.getPrivateKey(),fluent.getServerCertificate(),fluent.getSubjectAltNames(),fluent.getVerifyCertificateHash(),fluent.getVerifyCertificateSpki());
    return buildable;
  }
  
}