package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessProbeTcpSocketBuilder extends ReadinessProbeTcpSocketFluentImpl<ReadinessProbeTcpSocketBuilder> implements VisitableBuilder<ReadinessProbeTcpSocket,ReadinessProbeTcpSocketBuilder>{
  public ReadinessProbeTcpSocketBuilder() {
    this(false);
  }
  public ReadinessProbeTcpSocketBuilder(Boolean validationEnabled) {
    this(new ReadinessProbeTcpSocket(), validationEnabled);
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocketFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocketFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessProbeTcpSocket(), validationEnabled);
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocketFluent<?> fluent,ReadinessProbeTcpSocket instance) {
    this(fluent, instance, false);
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocketFluent<?> fluent,ReadinessProbeTcpSocket instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocket instance) {
    this(instance,false);
  }
  public ReadinessProbeTcpSocketBuilder(ReadinessProbeTcpSocket instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withTcpSocket(instance.getTcpSocket());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReadinessProbeTcpSocketFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessProbeTcpSocket build() {
    ReadinessProbeTcpSocket buildable = new ReadinessProbeTcpSocket(fluent.getTcpSocket());
    return buildable;
  }
  
}