package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortSelectorBuilder extends PortSelectorFluentImpl<PortSelectorBuilder> implements VisitableBuilder<PortSelector,PortSelectorBuilder>{
  public PortSelectorBuilder() {
    this(false);
  }
  public PortSelectorBuilder(Boolean validationEnabled) {
    this(new PortSelector(), validationEnabled);
  }
  public PortSelectorBuilder(PortSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public PortSelectorBuilder(PortSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PortSelector(), validationEnabled);
  }
  public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance) {
    this(fluent, instance, false);
  }
  public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNumber(instance.getNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PortSelectorBuilder(PortSelector instance) {
    this(instance,false);
  }
  public PortSelectorBuilder(PortSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNumber(instance.getNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  PortSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public PortSelector build() {
    PortSelector buildable = new PortSelector(fluent.getNumber());
    return buildable;
  }
  
}