/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.connector.DevOpsConnector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="devops", requiresProject=false)
public class DevOpsMojo
extends AbstractNamespacedMojo {
    @Parameter(defaultValue="${basedir}")
    protected File basedir;
    @Parameter(property="fabric8.gogsUsername")
    protected String username;
    @Parameter(property="fabric8.gogsPassword")
    protected String password;
    @Parameter(property="fabric8.gogsBranch", defaultValue="master")
    protected String branch;
    @Parameter(property="fabric8.repoName", defaultValue="${project.artifactId}")
    protected String repoName;
    @Parameter(property="fabric8.fullName")
    protected String fullName;
    @Parameter(property="fabric8.gitUrl")
    protected String gitUrl;
    @Parameter(property="fabric8.webhookSecret", defaultValue="secret101")
    protected String secret;
    @Parameter(property="fabric8.buildImageStream", defaultValue="triggerJenkins")
    protected String buildImageStream;
    @Parameter(property="fabric8.buildImageTag", defaultValue="latest")
    protected String buildImageTag;
    @Parameter(property="fabric8.jenkinsJob")
    protected String jenkinsJob;
    @Parameter(property="fabric8.jenkinsMonitorView")
    protected String jenkinsMonitorView;
    @Parameter(property="fabric8.jenkinsPipelineView")
    protected String jenkinsPipelineView;
    @Parameter(property="fabric8.tagiaProjectName", defaultValue="${fabric8.repoName}")
    protected String taigaProjectName;
    @Parameter(property="fabric8.taigaProjectSlug")
    protected String taigaProjectSlug;
    @Parameter(property="fabric8.taigaProjectLinkPage", defaultValue="backlog")
    protected String taigaProjectLinkPage;
    @Parameter(property="fabric8.taigaProjectLinkLabel", defaultValue="Backlog")
    protected String taigaProjectLinkLabel;
    @Parameter(property="fabric8.taigaTeamLinkPage", defaultValue="team")
    protected String taigaTeamLinkPage;
    @Parameter(property="fabric8.taigaTeamLinkLabel", defaultValue="Team")
    protected String taigaTeamLinkLabel;
    @Parameter(property="fabric8.taigaAutoCreate", defaultValue="true")
    protected boolean taigaAutoCreate;
    @Parameter(property="fabric8.taigaEnabled", defaultValue="true")
    protected boolean taigaEnabled;
    @Parameter(property="fabric8.letschatEnabled", defaultValue="true")
    protected boolean letschatEnabled;
    @Parameter(property="fabric8.letschatRoomLinkLabel", defaultValue="Room")
    protected String letschatRoomLinkLabel;
    @Parameter(property="fabric8.letschatRoomLinkLabel", defaultValue="fabric8_${namespace}")
    protected String letschatRoomExpression;

    public void execute() throws MojoExecutionException, MojoFailureException {
        KubernetesClient kubernetes = this.getKubernetes();
        DevOpsConnector connector = new DevOpsConnector();
        connector.setKubernetes(kubernetes);
        connector.setUsername(this.username);
        connector.setPassword(this.password);
        connector.setBranch(this.branch);
        connector.setBasedir(this.basedir);
        connector.setRepoName(this.repoName);
        connector.setFullName(this.fullName);
        connector.setGitUrl(this.gitUrl);
        connector.setSecret(this.secret);
        connector.setBuildImageStream(this.buildImageStream);
        connector.setBuildImageTag(this.buildImageTag);
        connector.setJenkinsJob(this.jenkinsJob);
        connector.setJenkinsMonitorView(this.jenkinsMonitorView);
        connector.setJenkinsPipelineView(this.jenkinsPipelineView);
        connector.setTaigaProjectName(this.taigaProjectName);
        connector.setTaigaProjectSlug(this.taigaProjectSlug);
        connector.setTaigaProjectLinkPage(this.taigaProjectLinkPage);
        connector.setTaigaProjectLinkLabel(this.taigaProjectLinkLabel);
        connector.setTaigaTeamLinkPage(this.taigaTeamLinkPage);
        connector.setTaigaTeamLinkLabel(this.taigaTeamLinkLabel);
        connector.setTaigaAutoCreate(this.taigaAutoCreate);
        connector.setTaigaEnabled(this.taigaEnabled);
        connector.setLetschatEnabled(this.letschatEnabled);
        connector.setLetschatRoomLinkLabel(this.letschatRoomLinkLabel);
        connector.setLetschatRoomExpression(this.letschatRoomExpression);
        this.getLog().debug((CharSequence)("Using connector: " + connector));
        try {
            connector.execute();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to update DevOps resources: " + e), (Throwable)e);
            throw new MojoExecutionException("Failed to update DevOps resources: " + e, e);
        }
    }
}

