/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.maven.ApplyMojo;
import io.fabric8.openshift.client.OpenShiftClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="clean", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CleanMojo
extends ApplyMojo {
    @Parameter(property="fabric8.deep.clean", defaultValue="false")
    private Boolean deep;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        KubernetesClient client = this.getKubernetes();
        this.delete((Deletable<Boolean>)client.services());
        this.delete((Deletable<Boolean>)client.replicationControllers());
        this.delete((Deletable<Boolean>)client.pods());
        this.delete((Deletable<Boolean>)client.endpoints());
        this.delete((Deletable<Boolean>)client.events());
        if (this.deep.booleanValue()) {
            this.delete((Deletable<Boolean>)client.secrets());
            this.delete((Deletable<Boolean>)client.serviceAccounts());
            this.delete((Deletable<Boolean>)client.securityContextConstraints());
        }
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            this.delete((Deletable<Boolean>)openShiftClient.routes());
            this.delete((Deletable<Boolean>)openShiftClient.builds());
            this.delete((Deletable<Boolean>)openShiftClient.imageStreams());
            this.delete((Deletable<Boolean>)openShiftClient.buildConfigs());
            this.delete((Deletable<Boolean>)openShiftClient.deploymentConfigs());
            if (this.deep.booleanValue()) {
                this.delete((Deletable<Boolean>)openShiftClient.templates());
            }
        }
    }

    public Boolean delete(Deletable<Boolean> deletable) {
        try {
            return (Boolean)deletable.delete();
        }
        catch (KubernetesClientException e) {
            this.getLog().error((CharSequence)e.getMessage());
            return false;
        }
    }
}

