/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jgroups;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MBean(description="Kubernetes discovery protocol")
public class KubernetesDiscovery
extends Discovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesDiscovery.class);
    @Property
    private String address;
    private KubernetesClient client;
    private List<PhysicalAddress> kubernetesHosts = Collections.emptyList();
    private BoundedList<PhysicalAddress> dynamic_hosts = new BoundedList(2000);

    public void init() throws Exception {
        super.init();
        this.client = !Strings.isNullOrBlank((String)this.address) ? new DefaultKubernetesClient((Config)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.address)).build()) : new DefaultKubernetesClient();
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.members) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, (Object)logical_addr));
                    if (physical_addr == null || this.kubernetesHosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent((Object)physical_addr);
                }
                break;
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr == null || this.kubernetesHosts.contains(physical_addr)) break;
                this.dynamic_hosts.addIfAbsent((Object)physical_addr);
            }
        }
        return retval;
    }

    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        if (physical_addr != null && !this.kubernetesHosts.contains(physical_addr)) {
            this.dynamic_hosts.addIfAbsent((Object)physical_addr);
        }
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        Collection list;
        this.kubernetesHosts = this.findKubernetesHosts();
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        PingData data = new PingData(this.local_addr, false, UUID.get((Address)this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        HashSet<PhysicalAddress> cluster_members = new HashSet<PhysicalAddress>(this.kubernetesHosts);
        cluster_members.addAll((Collection<PhysicalAddress>)this.dynamic_hosts);
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            for (PhysicalAddress phys_addr : list) {
                if (cluster_members.contains(phys_addr)) continue;
                cluster_members.add(phys_addr);
            }
        }
        for (PhysicalAddress addr : cluster_members) {
            if (physical_addr != null && addr.equals(physical_addr)) continue;
            Message msg = new Message((Address)addr).setFlag(new Message.Flag[]{Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB}).putHeader(this.id, (Header)hdr).setBuffer(KubernetesDiscovery.marshal((PingData)data));
            this.log.trace("%s: sending discovery request to %s", new Object[]{this.local_addr, msg.getDest()});
            this.down_prot.down(new Event(1, (Object)msg));
        }
    }

    public List<PhysicalAddress> findKubernetesHosts() {
        ArrayList<PhysicalAddress> addresses = new ArrayList<PhysicalAddress>();
        Map<String, String> labels = Collections.singletonMap("cluster", this.cluster_name);
        for (Pod pod : ((PodList)((FilterWatchListDeletable)this.client.pods().withLabels(labels)).list()).getItems()) {
            List containers = KubernetesHelper.getContainers((Pod)pod);
            for (Container container : containers) {
                for (ContainerPort port : container.getPorts()) {
                    if (!"jgroups-tcp-port".equals(port.getName())) continue;
                    try {
                        String ip = pod.getStatus().getPodIP();
                        if (ip == null) continue;
                        addresses.add((PhysicalAddress)new IpAddress(ip, port.getContainerPort().intValue()));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Failed to create Address {}.", (Object)pod.getStatus().getPodIP());
                    }
                }
            }
        }
        return addresses;
    }

    public boolean isDynamic() {
        return true;
    }

    private static List<Pod> filterPods(List<Pod> pods, Filter<Pod> podFilter) {
        ArrayList<Pod> result = new ArrayList<Pod>();
        for (Pod pod : pods) {
            if (!podFilter.matches((Object)pod)) continue;
            result.add(pod);
        }
        return result;
    }
}

