package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeChaosStatusBuilder extends TimeChaosStatusFluentImpl<TimeChaosStatusBuilder> implements VisitableBuilder<TimeChaosStatus,TimeChaosStatusBuilder>{
  public TimeChaosStatusBuilder() {
    this(false);
  }
  public TimeChaosStatusBuilder(Boolean validationEnabled) {
    this(new TimeChaosStatus(), validationEnabled);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeChaosStatus(), validationEnabled);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance) {
    this(fluent, instance, false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TimeChaosStatusBuilder(TimeChaosStatus instance) {
    this(instance,false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
    }
    this.validationEnabled = validationEnabled; 
  }
  TimeChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TimeChaosStatus build() {
    TimeChaosStatus buildable = new TimeChaosStatus(fluent.getConditions(),fluent.getExperiment());
    return buildable;
  }
  
}