package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosStatusBuilder extends StressChaosStatusFluentImpl<StressChaosStatusBuilder> implements VisitableBuilder<StressChaosStatus,StressChaosStatusBuilder>{
  public StressChaosStatusBuilder() {
    this(false);
  }
  public StressChaosStatusBuilder(Boolean validationEnabled) {
    this(new StressChaosStatus(), validationEnabled);
  }
  public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaosStatus(), validationEnabled);
  }
  public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,StressChaosStatus instance) {
    this(fluent, instance, false);
  }
  public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,StressChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExperiment(instance.getExperiment());
      fluent.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosStatusBuilder(StressChaosStatus instance) {
    this(instance,false);
  }
  public StressChaosStatusBuilder(StressChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
      this.withInstances(instance.getInstances());
    }
    this.validationEnabled = validationEnabled; 
  }
  StressChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaosStatus build() {
    StressChaosStatus buildable = new StressChaosStatus(fluent.getConditions(),fluent.getExperiment(),fluent.getInstances());
    return buildable;
  }
  
}