package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosSpecBuilder extends StressChaosSpecFluentImpl<StressChaosSpecBuilder> implements VisitableBuilder<StressChaosSpec,StressChaosSpecBuilder>{
  public StressChaosSpecBuilder() {
    this(false);
  }
  public StressChaosSpecBuilder(Boolean validationEnabled) {
    this(new StressChaosSpec(), validationEnabled);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaosSpec(), validationEnabled);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,StressChaosSpec instance) {
    this(fluent, instance, false);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,StressChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainerNames(instance.getContainerNames());
      fluent.withDuration(instance.getDuration());
      fluent.withMode(instance.getMode());
      fluent.withSelector(instance.getSelector());
      fluent.withStressngStressors(instance.getStressngStressors());
      fluent.withStressors(instance.getStressors());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosSpecBuilder(StressChaosSpec instance) {
    this(instance,false);
  }
  public StressChaosSpecBuilder(StressChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainerNames(instance.getContainerNames());
      this.withDuration(instance.getDuration());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withStressngStressors(instance.getStressngStressors());
      this.withStressors(instance.getStressors());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  StressChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaosSpec build() {
    StressChaosSpec buildable = new StressChaosSpec(fluent.getContainerNames(),fluent.getDuration(),fluent.getMode(),fluent.getSelector(),fluent.getStressngStressors(),fluent.getStressors(),fluent.getValue());
    return buildable;
  }
  
}