package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosListBuilder extends StressChaosListFluentImpl<StressChaosListBuilder> implements VisitableBuilder<StressChaosList,StressChaosListBuilder>{
  public StressChaosListBuilder() {
    this(false);
  }
  public StressChaosListBuilder(Boolean validationEnabled) {
    this(new StressChaosList(), validationEnabled);
  }
  public StressChaosListBuilder(StressChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosListBuilder(StressChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaosList(), validationEnabled);
  }
  public StressChaosListBuilder(StressChaosListFluent<?> fluent,StressChaosList instance) {
    this(fluent, instance, false);
  }
  public StressChaosListBuilder(StressChaosListFluent<?> fluent,StressChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosListBuilder(StressChaosList instance) {
    this(instance,false);
  }
  public StressChaosListBuilder(StressChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  StressChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaosList build() {
    StressChaosList buildable = new StressChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}