package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReorderSpecBuilder extends ReorderSpecFluentImpl<ReorderSpecBuilder> implements VisitableBuilder<ReorderSpec,ReorderSpecBuilder>{
  public ReorderSpecBuilder() {
    this(false);
  }
  public ReorderSpecBuilder(Boolean validationEnabled) {
    this(new ReorderSpec(), validationEnabled);
  }
  public ReorderSpecBuilder(ReorderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReorderSpec(), validationEnabled);
  }
  public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,ReorderSpec instance) {
    this(fluent, instance, false);
  }
  public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,ReorderSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withGap(instance.getGap());
      fluent.withReorder(instance.getReorder());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReorderSpecBuilder(ReorderSpec instance) {
    this(instance,false);
  }
  public ReorderSpecBuilder(ReorderSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCorrelation(instance.getCorrelation());
      this.withGap(instance.getGap());
      this.withReorder(instance.getReorder());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReorderSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ReorderSpec build() {
    ReorderSpec buildable = new ReorderSpec(fluent.getCorrelation(),fluent.getGap(),fluent.getReorder());
    return buildable;
  }
  
}