package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RecordBuilder extends RecordFluentImpl<RecordBuilder> implements VisitableBuilder<Record,RecordBuilder>{
  public RecordBuilder() {
    this(false);
  }
  public RecordBuilder(Boolean validationEnabled) {
    this(new Record(), validationEnabled);
  }
  public RecordBuilder(RecordFluent<?> fluent) {
    this(fluent, false);
  }
  public RecordBuilder(RecordFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Record(), validationEnabled);
  }
  public RecordBuilder(RecordFluent<?> fluent,Record instance) {
    this(fluent, instance, false);
  }
  public RecordBuilder(RecordFluent<?> fluent,Record instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withPhase(instance.getPhase());
      fluent.withSelectorKey(instance.getSelectorKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RecordBuilder(Record instance) {
    this(instance,false);
  }
  public RecordBuilder(Record instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withId(instance.getId());
      this.withPhase(instance.getPhase());
      this.withSelectorKey(instance.getSelectorKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  RecordFluent<?> fluent;
  Boolean validationEnabled;
  public Record build() {
    Record buildable = new Record(fluent.getId(),fluent.getPhase(),fluent.getSelectorKey());
    return buildable;
  }
  
}