package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProcessSpecBuilder extends ProcessSpecFluentImpl<ProcessSpecBuilder> implements VisitableBuilder<ProcessSpec,ProcessSpecBuilder>{
  public ProcessSpecBuilder() {
    this(false);
  }
  public ProcessSpecBuilder(Boolean validationEnabled) {
    this(new ProcessSpec(), validationEnabled);
  }
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProcessSpec(), validationEnabled);
  }
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent,ProcessSpec instance) {
    this(fluent, instance, false);
  }
  public ProcessSpecBuilder(ProcessSpecFluent<?> fluent,ProcessSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withProcess(instance.getProcess());
      fluent.withSignal(instance.getSignal());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProcessSpecBuilder(ProcessSpec instance) {
    this(instance,false);
  }
  public ProcessSpecBuilder(ProcessSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withProcess(instance.getProcess());
      this.withSignal(instance.getSignal());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProcessSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProcessSpec build() {
    ProcessSpec buildable = new ProcessSpec(fluent.getProcess(),fluent.getSignal());
    return buildable;
  }
  
}