package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSelectorSpecBuilder extends PodSelectorSpecFluentImpl<PodSelectorSpecBuilder> implements VisitableBuilder<PodSelectorSpec,PodSelectorSpecBuilder>{
  public PodSelectorSpecBuilder() {
    this(false);
  }
  public PodSelectorSpecBuilder(Boolean validationEnabled) {
    this(new PodSelectorSpec(), validationEnabled);
  }
  public PodSelectorSpecBuilder(PodSelectorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSelectorSpecBuilder(PodSelectorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSelectorSpec(), validationEnabled);
  }
  public PodSelectorSpecBuilder(PodSelectorSpecFluent<?> fluent,PodSelectorSpec instance) {
    this(fluent, instance, false);
  }
  public PodSelectorSpecBuilder(PodSelectorSpecFluent<?> fluent,PodSelectorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotationSelectors(instance.getAnnotationSelectors());
      fluent.withExpressionSelectors(instance.getExpressionSelectors());
      fluent.withFieldSelectors(instance.getFieldSelectors());
      fluent.withLabelSelectors(instance.getLabelSelectors());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withNodeSelectors(instance.getNodeSelectors());
      fluent.withNodes(instance.getNodes());
      fluent.withPodPhaseSelectors(instance.getPodPhaseSelectors());
      fluent.withPods(instance.getPods());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSelectorSpecBuilder(PodSelectorSpec instance) {
    this(instance,false);
  }
  public PodSelectorSpecBuilder(PodSelectorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotationSelectors(instance.getAnnotationSelectors());
      this.withExpressionSelectors(instance.getExpressionSelectors());
      this.withFieldSelectors(instance.getFieldSelectors());
      this.withLabelSelectors(instance.getLabelSelectors());
      this.withNamespaces(instance.getNamespaces());
      this.withNodeSelectors(instance.getNodeSelectors());
      this.withNodes(instance.getNodes());
      this.withPodPhaseSelectors(instance.getPodPhaseSelectors());
      this.withPods(instance.getPods());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSelectorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSelectorSpec build() {
    PodSelectorSpec buildable = new PodSelectorSpec(fluent.getAnnotationSelectors(),fluent.getExpressionSelectors(),fluent.getFieldSelectors(),fluent.getLabelSelectors(),fluent.getNamespaces(),fluent.getNodeSelectors(),fluent.getNodes(),fluent.getPodPhaseSelectors(),fluent.getPods());
    return buildable;
  }
  
}