package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkChaosStatusBuilder extends PodNetworkChaosStatusFluentImpl<PodNetworkChaosStatusBuilder> implements VisitableBuilder<PodNetworkChaosStatus,PodNetworkChaosStatusBuilder>{
  public PodNetworkChaosStatusBuilder() {
    this(false);
  }
  public PodNetworkChaosStatusBuilder(Boolean validationEnabled) {
    this(new PodNetworkChaosStatus(), validationEnabled);
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkChaosStatus(), validationEnabled);
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatusFluent<?> fluent,PodNetworkChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatusFluent<?> fluent,PodNetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFailedMessage(instance.getFailedMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatus instance) {
    this(instance,false);
  }
  public PodNetworkChaosStatusBuilder(PodNetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFailedMessage(instance.getFailedMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkChaosStatus build() {
    PodNetworkChaosStatus buildable = new PodNetworkChaosStatus(fluent.getFailedMessage(),fluent.getObservedGeneration());
    return buildable;
  }
  
}