package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkChaosSpecBuilder extends PodNetworkChaosSpecFluentImpl<PodNetworkChaosSpecBuilder> implements VisitableBuilder<PodNetworkChaosSpec,PodNetworkChaosSpecBuilder>{
  public PodNetworkChaosSpecBuilder() {
    this(false);
  }
  public PodNetworkChaosSpecBuilder(Boolean validationEnabled) {
    this(new PodNetworkChaosSpec(), validationEnabled);
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkChaosSpec(), validationEnabled);
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpecFluent<?> fluent,PodNetworkChaosSpec instance) {
    this(fluent, instance, false);
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpecFluent<?> fluent,PodNetworkChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withIpsets(instance.getIpsets());
      fluent.withIptables(instance.getIptables());
      fluent.withTcs(instance.getTcs());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpec instance) {
    this(instance,false);
  }
  public PodNetworkChaosSpecBuilder(PodNetworkChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withIpsets(instance.getIpsets());
      this.withIptables(instance.getIptables());
      this.withTcs(instance.getTcs());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkChaosSpec build() {
    PodNetworkChaosSpec buildable = new PodNetworkChaosSpec(fluent.getIpsets(),fluent.getIptables(),fluent.getTcs());
    return buildable;
  }
  
}