package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIOChaosSpecBuilder extends PodIOChaosSpecFluentImpl<PodIOChaosSpecBuilder> implements VisitableBuilder<PodIOChaosSpec,PodIOChaosSpecBuilder>{
  public PodIOChaosSpecBuilder() {
    this(false);
  }
  public PodIOChaosSpecBuilder(Boolean validationEnabled) {
    this(new PodIOChaosSpec(), validationEnabled);
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIOChaosSpec(), validationEnabled);
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpecFluent<?> fluent,PodIOChaosSpec instance) {
    this(fluent, instance, false);
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpecFluent<?> fluent,PodIOChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withActions(instance.getActions());
      fluent.withContainer(instance.getContainer());
      fluent.withVolumeMountPath(instance.getVolumeMountPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpec instance) {
    this(instance,false);
  }
  public PodIOChaosSpecBuilder(PodIOChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withActions(instance.getActions());
      this.withContainer(instance.getContainer());
      this.withVolumeMountPath(instance.getVolumeMountPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodIOChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodIOChaosSpec build() {
    PodIOChaosSpec buildable = new PodIOChaosSpec(fluent.getActions(),fluent.getContainer(),fluent.getVolumeMountPath());
    return buildable;
  }
  
}