package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosSpecBuilder extends PodHttpChaosSpecFluentImpl<PodHttpChaosSpecBuilder> implements VisitableBuilder<PodHttpChaosSpec,PodHttpChaosSpecBuilder>{
  public PodHttpChaosSpecBuilder() {
    this(false);
  }
  public PodHttpChaosSpecBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosSpec(), validationEnabled);
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosSpec(), validationEnabled);
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpecFluent<?> fluent,PodHttpChaosSpec instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpecFluent<?> fluent,PodHttpChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRules(instance.getRules());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpec instance) {
    this(instance,false);
  }
  public PodHttpChaosSpecBuilder(PodHttpChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRules(instance.getRules());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosSpec build() {
    PodHttpChaosSpec buildable = new PodHttpChaosSpec(fluent.getRules());
    return buildable;
  }
  
}