package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosSelectorBuilder extends PodHttpChaosSelectorFluentImpl<PodHttpChaosSelectorBuilder> implements VisitableBuilder<PodHttpChaosSelector,PodHttpChaosSelectorBuilder>{
  public PodHttpChaosSelectorBuilder() {
    this(false);
  }
  public PodHttpChaosSelectorBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosSelector(), validationEnabled);
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosSelector(), validationEnabled);
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelectorFluent<?> fluent,PodHttpChaosSelector instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelectorFluent<?> fluent,PodHttpChaosSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCode(instance.getCode());
      fluent.withMethod(instance.getMethod());
      fluent.withPath(instance.getPath());
      fluent.withPort(instance.getPort());
      fluent.withRequestHeaders(instance.getRequestHeaders());
      fluent.withResponseHeaders(instance.getResponseHeaders());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelector instance) {
    this(instance,false);
  }
  public PodHttpChaosSelectorBuilder(PodHttpChaosSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCode(instance.getCode());
      this.withMethod(instance.getMethod());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withRequestHeaders(instance.getRequestHeaders());
      this.withResponseHeaders(instance.getResponseHeaders());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosSelector build() {
    PodHttpChaosSelector buildable = new PodHttpChaosSelector(fluent.getCode(),fluent.getMethod(),fluent.getPath(),fluent.getPort(),fluent.getRequestHeaders(),fluent.getResponseHeaders());
    return buildable;
  }
  
}