package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosListBuilder extends PodHttpChaosListFluentImpl<PodHttpChaosListBuilder> implements VisitableBuilder<PodHttpChaosList,PodHttpChaosListBuilder>{
  public PodHttpChaosListBuilder() {
    this(false);
  }
  public PodHttpChaosListBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosList(), validationEnabled);
  }
  public PodHttpChaosListBuilder(PodHttpChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosListBuilder(PodHttpChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosList(), validationEnabled);
  }
  public PodHttpChaosListBuilder(PodHttpChaosListFluent<?> fluent,PodHttpChaosList instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosListBuilder(PodHttpChaosListFluent<?> fluent,PodHttpChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosListBuilder(PodHttpChaosList instance) {
    this(instance,false);
  }
  public PodHttpChaosListBuilder(PodHttpChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosList build() {
    PodHttpChaosList buildable = new PodHttpChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}