package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosActionsBuilder extends PodHttpChaosActionsFluentImpl<PodHttpChaosActionsBuilder> implements VisitableBuilder<PodHttpChaosActions,PodHttpChaosActionsBuilder>{
  public PodHttpChaosActionsBuilder() {
    this(false);
  }
  public PodHttpChaosActionsBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosActions(), validationEnabled);
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosActions(), validationEnabled);
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActionsFluent<?> fluent,PodHttpChaosActions instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActionsFluent<?> fluent,PodHttpChaosActions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAbort(instance.getAbort());
      fluent.withDelay(instance.getDelay());
      fluent.withPatch(instance.getPatch());
      fluent.withReplace(instance.getReplace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActions instance) {
    this(instance,false);
  }
  public PodHttpChaosActionsBuilder(PodHttpChaosActions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAbort(instance.getAbort());
      this.withDelay(instance.getDelay());
      this.withPatch(instance.getPatch());
      this.withReplace(instance.getReplace());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosActionsFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosActions build() {
    PodHttpChaosActions buildable = new PodHttpChaosActions(fluent.getAbort(),fluent.getDelay(),fluent.getPatch(),fluent.getReplace());
    return buildable;
  }
  
}