package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkDelaySpecBuilder extends NetworkDelaySpecFluentImpl<NetworkDelaySpecBuilder> implements VisitableBuilder<NetworkDelaySpec,NetworkDelaySpecBuilder>{
  public NetworkDelaySpecBuilder() {
    this(false);
  }
  public NetworkDelaySpecBuilder(Boolean validationEnabled) {
    this(new NetworkDelaySpec(), validationEnabled);
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkDelaySpec(), validationEnabled);
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpecFluent<?> fluent,NetworkDelaySpec instance) {
    this(fluent, instance, false);
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpecFluent<?> fluent,NetworkDelaySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withDevice(instance.getDevice());
      fluent.withEgressPort(instance.getEgressPort());
      fluent.withHostname(instance.getHostname());
      fluent.withIpAddress(instance.getIpAddress());
      fluent.withIpProtocol(instance.getIpProtocol());
      fluent.withJitter(instance.getJitter());
      fluent.withLatency(instance.getLatency());
      fluent.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpec instance) {
    this(instance,false);
  }
  public NetworkDelaySpecBuilder(NetworkDelaySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCorrelation(instance.getCorrelation());
      this.withDevice(instance.getDevice());
      this.withEgressPort(instance.getEgressPort());
      this.withHostname(instance.getHostname());
      this.withIpAddress(instance.getIpAddress());
      this.withIpProtocol(instance.getIpProtocol());
      this.withJitter(instance.getJitter());
      this.withLatency(instance.getLatency());
      this.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkDelaySpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkDelaySpec build() {
    NetworkDelaySpec buildable = new NetworkDelaySpec(fluent.getCorrelation(),fluent.getDevice(),fluent.getEgressPort(),fluent.getHostname(),fluent.getIpAddress(),fluent.getIpProtocol(),fluent.getJitter(),fluent.getLatency(),fluent.getSourcePort());
    return buildable;
  }
  
}