package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkChaosSpecFluentImpl<A extends NetworkChaosSpecFluent<A>> extends BaseFluent<A> implements NetworkChaosSpecFluent<A>{
  public NetworkChaosSpecFluentImpl() {
  }
  public NetworkChaosSpecFluentImpl(NetworkChaosSpec instance) {
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withBandwidth(instance.getBandwidth());
      this.withCorrupt(instance.getCorrupt());
      this.withDelay(instance.getDelay());
      this.withDevice(instance.getDevice());
      this.withDirection(instance.getDirection());
      this.withDuplicate(instance.getDuplicate());
      this.withDuration(instance.getDuration());
      this.withExternalTargets(instance.getExternalTargets());
      this.withLoss(instance.getLoss());
      this.withMode(instance.getMode());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withTargetDevice(instance.getTargetDevice());
      this.withValue(instance.getValue());
    }
  }
  private String action;
  private BandwidthSpecBuilder bandwidth;
  private CorruptSpecBuilder corrupt;
  private DelaySpecBuilder delay;
  private String device;
  private String direction;
  private DuplicateSpecBuilder duplicate;
  private String duration;
  private List<String> externalTargets = new ArrayList<String>();
  private LossSpecBuilder loss;
  private String mode;
  private PodSelectorSpecBuilder selector;
  private PodSelectorBuilder target;
  private String targetDevice;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBandwidth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BandwidthSpec getBandwidth() {
    return this.bandwidth!=null ?this.bandwidth.build():null;
  }
  public BandwidthSpec buildBandwidth() {
    return this.bandwidth!=null ?this.bandwidth.build():null;
  }
  public A withBandwidth(BandwidthSpec bandwidth) {
    _visitables.get("bandwidth").remove(this.bandwidth);
    if (bandwidth!=null){ this.bandwidth= new BandwidthSpecBuilder(bandwidth); _visitables.get("bandwidth").add(this.bandwidth);} else { this.bandwidth = null; _visitables.get("bandwidth").remove(this.bandwidth); } return (A) this;
  }
  public Boolean hasBandwidth() {
    return this.bandwidth != null;
  }
  public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
    return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
  }
  public NetworkChaosSpecFluentImpl.BandwidthNested<A> withNewBandwidth() {
    return new NetworkChaosSpecFluentImpl.BandwidthNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
    return new NetworkChaosSpecFluentImpl.BandwidthNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.BandwidthNested<A> editBandwidth() {
    return withNewBandwidthLike(getBandwidth());
  }
  public NetworkChaosSpecFluentImpl.BandwidthNested<A> editOrNewBandwidth() {
    return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): new BandwidthSpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
    return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCorrupt instead.
   * @return The buildable object.
   */
  @Deprecated
  public CorruptSpec getCorrupt() {
    return this.corrupt!=null ?this.corrupt.build():null;
  }
  public CorruptSpec buildCorrupt() {
    return this.corrupt!=null ?this.corrupt.build():null;
  }
  public A withCorrupt(CorruptSpec corrupt) {
    _visitables.get("corrupt").remove(this.corrupt);
    if (corrupt!=null){ this.corrupt= new CorruptSpecBuilder(corrupt); _visitables.get("corrupt").add(this.corrupt);} else { this.corrupt = null; _visitables.get("corrupt").remove(this.corrupt); } return (A) this;
  }
  public Boolean hasCorrupt() {
    return this.corrupt != null;
  }
  public A withNewCorrupt(String correlation,String corrupt) {
    return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
  }
  public NetworkChaosSpecFluentImpl.CorruptNested<A> withNewCorrupt() {
    return new NetworkChaosSpecFluentImpl.CorruptNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
    return new NetworkChaosSpecFluentImpl.CorruptNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.CorruptNested<A> editCorrupt() {
    return withNewCorruptLike(getCorrupt());
  }
  public NetworkChaosSpecFluentImpl.CorruptNested<A> editOrNewCorrupt() {
    return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): new CorruptSpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
    return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDelay instead.
   * @return The buildable object.
   */
  @Deprecated
  public DelaySpec getDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public DelaySpec buildDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public A withDelay(DelaySpec delay) {
    _visitables.get("delay").remove(this.delay);
    if (delay!=null){ this.delay= new DelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} else { this.delay = null; _visitables.get("delay").remove(this.delay); } return (A) this;
  }
  public Boolean hasDelay() {
    return this.delay != null;
  }
  public NetworkChaosSpecFluentImpl.DelayNested<A> withNewDelay() {
    return new NetworkChaosSpecFluentImpl.DelayNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.DelayNested<A> withNewDelayLike(DelaySpec item) {
    return new NetworkChaosSpecFluentImpl.DelayNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.DelayNested<A> editDelay() {
    return withNewDelayLike(getDelay());
  }
  public NetworkChaosSpecFluentImpl.DelayNested<A> editOrNewDelay() {
    return withNewDelayLike(getDelay() != null ? getDelay(): new DelaySpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.DelayNested<A> editOrNewDelayLike(DelaySpec item) {
    return withNewDelayLike(getDelay() != null ? getDelay(): item);
  }
  public String getDevice() {
    return this.device;
  }
  public A withDevice(String device) {
    this.device=device; return (A) this;
  }
  public Boolean hasDevice() {
    return this.device != null;
  }
  public String getDirection() {
    return this.direction;
  }
  public A withDirection(String direction) {
    this.direction=direction; return (A) this;
  }
  public Boolean hasDirection() {
    return this.direction != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDuplicate instead.
   * @return The buildable object.
   */
  @Deprecated
  public DuplicateSpec getDuplicate() {
    return this.duplicate!=null ?this.duplicate.build():null;
  }
  public DuplicateSpec buildDuplicate() {
    return this.duplicate!=null ?this.duplicate.build():null;
  }
  public A withDuplicate(DuplicateSpec duplicate) {
    _visitables.get("duplicate").remove(this.duplicate);
    if (duplicate!=null){ this.duplicate= new DuplicateSpecBuilder(duplicate); _visitables.get("duplicate").add(this.duplicate);} else { this.duplicate = null; _visitables.get("duplicate").remove(this.duplicate); } return (A) this;
  }
  public Boolean hasDuplicate() {
    return this.duplicate != null;
  }
  public A withNewDuplicate(String correlation,String duplicate) {
    return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
  }
  public NetworkChaosSpecFluentImpl.DuplicateNested<A> withNewDuplicate() {
    return new NetworkChaosSpecFluentImpl.DuplicateNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
    return new NetworkChaosSpecFluentImpl.DuplicateNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.DuplicateNested<A> editDuplicate() {
    return withNewDuplicateLike(getDuplicate());
  }
  public NetworkChaosSpecFluentImpl.DuplicateNested<A> editOrNewDuplicate() {
    return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): new DuplicateSpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
    return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): item);
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToExternalTargets(int index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.add(index, item);
    return (A)this;
  }
  public A setToExternalTargets(int index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.set(index, item); return (A)this;
  }
  public A addToExternalTargets(java.lang.String... items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A addAllToExternalTargets(Collection<String> items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A removeFromExternalTargets(java.lang.String... items) {
    for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalTargets(Collection<String> items) {
    for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
  }
  public List<String> getExternalTargets() {
    return this.externalTargets;
  }
  public String getExternalTarget(int index) {
    return this.externalTargets.get(index);
  }
  public String getFirstExternalTarget() {
    return this.externalTargets.get(0);
  }
  public String getLastExternalTarget() {
    return this.externalTargets.get(externalTargets.size() - 1);
  }
  public String getMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalTargets(List<String> externalTargets) {
    if (externalTargets != null) {this.externalTargets = new ArrayList(); for (String item : externalTargets){this.addToExternalTargets(item);}} else { this.externalTargets = null;} return (A) this;
  }
  public A withExternalTargets(java.lang.String... externalTargets) {
    if (this.externalTargets != null) {this.externalTargets.clear(); _visitables.remove("externalTargets"); }
    if (externalTargets != null) {for (String item :externalTargets){ this.addToExternalTargets(item);}} return (A) this;
  }
  public Boolean hasExternalTargets() {
    return externalTargets != null && !externalTargets.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildLoss instead.
   * @return The buildable object.
   */
  @Deprecated
  public LossSpec getLoss() {
    return this.loss!=null ?this.loss.build():null;
  }
  public LossSpec buildLoss() {
    return this.loss!=null ?this.loss.build():null;
  }
  public A withLoss(LossSpec loss) {
    _visitables.get("loss").remove(this.loss);
    if (loss!=null){ this.loss= new LossSpecBuilder(loss); _visitables.get("loss").add(this.loss);} else { this.loss = null; _visitables.get("loss").remove(this.loss); } return (A) this;
  }
  public Boolean hasLoss() {
    return this.loss != null;
  }
  public A withNewLoss(String correlation,String loss) {
    return (A)withLoss(new LossSpec(correlation, loss));
  }
  public NetworkChaosSpecFluentImpl.LossNested<A> withNewLoss() {
    return new NetworkChaosSpecFluentImpl.LossNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.LossNested<A> withNewLossLike(LossSpec item) {
    return new NetworkChaosSpecFluentImpl.LossNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.LossNested<A> editLoss() {
    return withNewLossLike(getLoss());
  }
  public NetworkChaosSpecFluentImpl.LossNested<A> editOrNewLoss() {
    return withNewLossLike(getLoss() != null ? getLoss(): new LossSpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.LossNested<A> editOrNewLossLike(LossSpec item) {
    return withNewLossLike(getLoss() != null ? getLoss(): item);
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public NetworkChaosSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new NetworkChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new NetworkChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public NetworkChaosSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelector getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public PodSelector buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(PodSelector target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new PodSelectorBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public NetworkChaosSpecFluentImpl.TargetNested<A> withNewTarget() {
    return new NetworkChaosSpecFluentImpl.TargetNestedImpl();
  }
  public NetworkChaosSpecFluentImpl.TargetNested<A> withNewTargetLike(PodSelector item) {
    return new NetworkChaosSpecFluentImpl.TargetNestedImpl(item);
  }
  public NetworkChaosSpecFluentImpl.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public NetworkChaosSpecFluentImpl.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new PodSelectorBuilder().build());
  }
  public NetworkChaosSpecFluentImpl.TargetNested<A> editOrNewTargetLike(PodSelector item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public String getTargetDevice() {
    return this.targetDevice;
  }
  public A withTargetDevice(String targetDevice) {
    this.targetDevice=targetDevice; return (A) this;
  }
  public Boolean hasTargetDevice() {
    return this.targetDevice != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkChaosSpecFluentImpl that = (NetworkChaosSpecFluentImpl) o;
    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(bandwidth, that.bandwidth)) return false;

    if (!java.util.Objects.equals(corrupt, that.corrupt)) return false;

    if (!java.util.Objects.equals(delay, that.delay)) return false;

    if (!java.util.Objects.equals(device, that.device)) return false;

    if (!java.util.Objects.equals(direction, that.direction)) return false;

    if (!java.util.Objects.equals(duplicate, that.duplicate)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(externalTargets, that.externalTargets)) return false;

    if (!java.util.Objects.equals(loss, that.loss)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(target, that.target)) return false;

    if (!java.util.Objects.equals(targetDevice, that.targetDevice)) return false;

    if (!java.util.Objects.equals(value, that.value)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  bandwidth,  corrupt,  delay,  device,  direction,  duplicate,  duration,  externalTargets,  loss,  mode,  selector,  target,  targetDevice,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (bandwidth != null) { sb.append("bandwidth:"); sb.append(bandwidth + ","); }
    if (corrupt != null) { sb.append("corrupt:"); sb.append(corrupt + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (device != null) { sb.append("device:"); sb.append(device + ","); }
    if (direction != null) { sb.append("direction:"); sb.append(direction + ","); }
    if (duplicate != null) { sb.append("duplicate:"); sb.append(duplicate + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (externalTargets != null && !externalTargets.isEmpty()) { sb.append("externalTargets:"); sb.append(externalTargets + ","); }
    if (loss != null) { sb.append("loss:"); sb.append(loss + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (targetDevice != null) { sb.append("targetDevice:"); sb.append(targetDevice + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class BandwidthNestedImpl<N> extends BandwidthSpecFluentImpl<NetworkChaosSpecFluentImpl.BandwidthNested<N>> implements NetworkChaosSpecFluentImpl.BandwidthNested<N>,Nested<N>{
    BandwidthNestedImpl(BandwidthSpec item) {
      this.builder = new BandwidthSpecBuilder(this, item);
    }
    BandwidthNestedImpl() {
      this.builder = new BandwidthSpecBuilder(this);
    }
    BandwidthSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withBandwidth(builder.build());
    }
    public N endBandwidth() {
      return and();
    }
    
  }
  class CorruptNestedImpl<N> extends CorruptSpecFluentImpl<NetworkChaosSpecFluentImpl.CorruptNested<N>> implements NetworkChaosSpecFluentImpl.CorruptNested<N>,Nested<N>{
    CorruptNestedImpl(CorruptSpec item) {
      this.builder = new CorruptSpecBuilder(this, item);
    }
    CorruptNestedImpl() {
      this.builder = new CorruptSpecBuilder(this);
    }
    CorruptSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withCorrupt(builder.build());
    }
    public N endCorrupt() {
      return and();
    }
    
  }
  class DelayNestedImpl<N> extends DelaySpecFluentImpl<NetworkChaosSpecFluentImpl.DelayNested<N>> implements NetworkChaosSpecFluentImpl.DelayNested<N>,Nested<N>{
    DelayNestedImpl(DelaySpec item) {
      this.builder = new DelaySpecBuilder(this, item);
    }
    DelayNestedImpl() {
      this.builder = new DelaySpecBuilder(this);
    }
    DelaySpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withDelay(builder.build());
    }
    public N endDelay() {
      return and();
    }
    
  }
  class DuplicateNestedImpl<N> extends DuplicateSpecFluentImpl<NetworkChaosSpecFluentImpl.DuplicateNested<N>> implements NetworkChaosSpecFluentImpl.DuplicateNested<N>,Nested<N>{
    DuplicateNestedImpl(DuplicateSpec item) {
      this.builder = new DuplicateSpecBuilder(this, item);
    }
    DuplicateNestedImpl() {
      this.builder = new DuplicateSpecBuilder(this);
    }
    DuplicateSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withDuplicate(builder.build());
    }
    public N endDuplicate() {
      return and();
    }
    
  }
  class LossNestedImpl<N> extends LossSpecFluentImpl<NetworkChaosSpecFluentImpl.LossNested<N>> implements NetworkChaosSpecFluentImpl.LossNested<N>,Nested<N>{
    LossNestedImpl(LossSpec item) {
      this.builder = new LossSpecBuilder(this, item);
    }
    LossNestedImpl() {
      this.builder = new LossSpecBuilder(this);
    }
    LossSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withLoss(builder.build());
    }
    public N endLoss() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<NetworkChaosSpecFluentImpl.SelectorNested<N>> implements NetworkChaosSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends PodSelectorFluentImpl<NetworkChaosSpecFluentImpl.TargetNested<N>> implements NetworkChaosSpecFluentImpl.TargetNested<N>,Nested<N>{
    TargetNestedImpl(PodSelector item) {
      this.builder = new PodSelectorBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new PodSelectorBuilder(this);
    }
    PodSelectorBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}