package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkBandwidthSpecBuilder extends NetworkBandwidthSpecFluentImpl<NetworkBandwidthSpecBuilder> implements VisitableBuilder<NetworkBandwidthSpec,NetworkBandwidthSpecBuilder>{
  public NetworkBandwidthSpecBuilder() {
    this(false);
  }
  public NetworkBandwidthSpecBuilder(Boolean validationEnabled) {
    this(new NetworkBandwidthSpec(), validationEnabled);
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkBandwidthSpec(), validationEnabled);
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpecFluent<?> fluent,NetworkBandwidthSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpecFluent<?> fluent,NetworkBandwidthSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBuffer(instance.getBuffer());
      fluent.withDevice(instance.getDevice());
      fluent.withHostname(instance.getHostname());
      fluent.withIpAddress(instance.getIpAddress());
      fluent.withLimit(instance.getLimit());
      fluent.withMinburst(instance.getMinburst());
      fluent.withPeakrate(instance.getPeakrate());
      fluent.withRate(instance.getRate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpec instance) {
    this(instance,false);
  }
  public NetworkBandwidthSpecBuilder(NetworkBandwidthSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBuffer(instance.getBuffer());
      this.withDevice(instance.getDevice());
      this.withHostname(instance.getHostname());
      this.withIpAddress(instance.getIpAddress());
      this.withLimit(instance.getLimit());
      this.withMinburst(instance.getMinburst());
      this.withPeakrate(instance.getPeakrate());
      this.withRate(instance.getRate());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkBandwidthSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkBandwidthSpec build() {
    NetworkBandwidthSpec buildable = new NetworkBandwidthSpec(fluent.getBuffer(),fluent.getDevice(),fluent.getHostname(),fluent.getIpAddress(),fluent.getLimit(),fluent.getMinburst(),fluent.getPeakrate(),fluent.getRate());
    return buildable;
  }
  
}