package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMExceptionSpecBuilder extends JVMExceptionSpecFluentImpl<JVMExceptionSpecBuilder> implements VisitableBuilder<JVMExceptionSpec,JVMExceptionSpecBuilder>{
  public JVMExceptionSpecBuilder() {
    this(false);
  }
  public JVMExceptionSpecBuilder(Boolean validationEnabled) {
    this(new JVMExceptionSpec(), validationEnabled);
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMExceptionSpec(), validationEnabled);
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,JVMExceptionSpec instance) {
    this(fluent, instance, false);
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,JVMExceptionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withException(instance.getException());
      fluent.withMethod(instance.getMethod());
      fluent.withPid(instance.getPid());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpec instance) {
    this(instance,false);
  }
  public JVMExceptionSpecBuilder(JVMExceptionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withException(instance.getException());
      this.withMethod(instance.getMethod());
      this.withPid(instance.getPid());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  JVMExceptionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMExceptionSpec build() {
    JVMExceptionSpec buildable = new JVMExceptionSpec(fluent.getClassName(),fluent.getException(),fluent.getMethod(),fluent.getPid(),fluent.getPort());
    return buildable;
  }
  
}