package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMChaosSpecBuilder extends JVMChaosSpecFluentImpl<JVMChaosSpecBuilder> implements VisitableBuilder<JVMChaosSpec,JVMChaosSpecBuilder>{
  public JVMChaosSpecBuilder() {
    this(false);
  }
  public JVMChaosSpecBuilder(Boolean validationEnabled) {
    this(new JVMChaosSpec(), validationEnabled);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMChaosSpec(), validationEnabled);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance) {
    this(fluent, instance, false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAction(instance.getAction());
      fluent.withClassName(instance.getClassName());
      fluent.withContainerNames(instance.getContainerNames());
      fluent.withCpuCount(instance.getCpuCount());
      fluent.withDuration(instance.getDuration());
      fluent.withException(instance.getException());
      fluent.withLatency(instance.getLatency());
      fluent.withMemType(instance.getMemType());
      fluent.withMethod(instance.getMethod());
      fluent.withMode(instance.getMode());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withRuleData(instance.getRuleData());
      fluent.withSelector(instance.getSelector());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JVMChaosSpecBuilder(JVMChaosSpec instance) {
    this(instance,false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withClassName(instance.getClassName());
      this.withContainerNames(instance.getContainerNames());
      this.withCpuCount(instance.getCpuCount());
      this.withDuration(instance.getDuration());
      this.withException(instance.getException());
      this.withLatency(instance.getLatency());
      this.withMemType(instance.getMemType());
      this.withMethod(instance.getMethod());
      this.withMode(instance.getMode());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withRuleData(instance.getRuleData());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  JVMChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMChaosSpec build() {
    JVMChaosSpec buildable = new JVMChaosSpec(fluent.getAction(),fluent.getClassName(),fluent.getContainerNames(),fluent.getCpuCount(),fluent.getDuration(),fluent.getException(),fluent.getLatency(),fluent.getMemType(),fluent.getMethod(),fluent.getMode(),fluent.getName(),fluent.getPort(),fluent.getRuleData(),fluent.getSelector(),fluent.getValue());
    return buildable;
  }
  
}