package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMChaosBuilder extends JVMChaosFluentImpl<JVMChaosBuilder> implements VisitableBuilder<JVMChaos,JVMChaosBuilder>{
  public JVMChaosBuilder() {
    this(false);
  }
  public JVMChaosBuilder(Boolean validationEnabled) {
    this(new JVMChaos(), validationEnabled);
  }
  public JVMChaosBuilder(JVMChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMChaosBuilder(JVMChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMChaos(), validationEnabled);
  }
  public JVMChaosBuilder(JVMChaosFluent<?> fluent,JVMChaos instance) {
    this(fluent, instance, false);
  }
  public JVMChaosBuilder(JVMChaosFluent<?> fluent,JVMChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JVMChaosBuilder(JVMChaos instance) {
    this(instance,false);
  }
  public JVMChaosBuilder(JVMChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  JVMChaosFluent<?> fluent;
  Boolean validationEnabled;
  public JVMChaos build() {
    JVMChaos buildable = new JVMChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}