package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DuplicateSpecBuilder extends DuplicateSpecFluentImpl<DuplicateSpecBuilder> implements VisitableBuilder<DuplicateSpec,DuplicateSpecBuilder>{
  public DuplicateSpecBuilder() {
    this(false);
  }
  public DuplicateSpecBuilder(Boolean validationEnabled) {
    this(new DuplicateSpec(), validationEnabled);
  }
  public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DuplicateSpec(), validationEnabled);
  }
  public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,DuplicateSpec instance) {
    this(fluent, instance, false);
  }
  public DuplicateSpecBuilder(DuplicateSpecFluent<?> fluent,DuplicateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withDuplicate(instance.getDuplicate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DuplicateSpecBuilder(DuplicateSpec instance) {
    this(instance,false);
  }
  public DuplicateSpecBuilder(DuplicateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCorrelation(instance.getCorrelation());
      this.withDuplicate(instance.getDuplicate());
    }
    this.validationEnabled = validationEnabled; 
  }
  DuplicateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DuplicateSpec build() {
    DuplicateSpec buildable = new DuplicateSpec(fluent.getCorrelation(),fluent.getDuplicate());
    return buildable;
  }
  
}