package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CPUStressorBuilder extends CPUStressorFluentImpl<CPUStressorBuilder> implements VisitableBuilder<CPUStressor,CPUStressorBuilder>{
  public CPUStressorBuilder() {
    this(false);
  }
  public CPUStressorBuilder(Boolean validationEnabled) {
    this(new CPUStressor(), validationEnabled);
  }
  public CPUStressorBuilder(CPUStressorFluent<?> fluent) {
    this(fluent, false);
  }
  public CPUStressorBuilder(CPUStressorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CPUStressor(), validationEnabled);
  }
  public CPUStressorBuilder(CPUStressorFluent<?> fluent,CPUStressor instance) {
    this(fluent, instance, false);
  }
  public CPUStressorBuilder(CPUStressorFluent<?> fluent,CPUStressor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLoad(instance.getLoad());
      fluent.withOptions(instance.getOptions());
      fluent.withWorkers(instance.getWorkers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CPUStressorBuilder(CPUStressor instance) {
    this(instance,false);
  }
  public CPUStressorBuilder(CPUStressor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLoad(instance.getLoad());
      this.withOptions(instance.getOptions());
      this.withWorkers(instance.getWorkers());
    }
    this.validationEnabled = validationEnabled; 
  }
  CPUStressorFluent<?> fluent;
  Boolean validationEnabled;
  public CPUStressor build() {
    CPUStressor buildable = new CPUStressor(fluent.getLoad(),fluent.getOptions(),fluent.getWorkers());
    return buildable;
  }
  
}