package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BlockChaosListBuilder extends BlockChaosListFluentImpl<BlockChaosListBuilder> implements VisitableBuilder<BlockChaosList,BlockChaosListBuilder>{
  public BlockChaosListBuilder() {
    this(false);
  }
  public BlockChaosListBuilder(Boolean validationEnabled) {
    this(new BlockChaosList(), validationEnabled);
  }
  public BlockChaosListBuilder(BlockChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public BlockChaosListBuilder(BlockChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BlockChaosList(), validationEnabled);
  }
  public BlockChaosListBuilder(BlockChaosListFluent<?> fluent,BlockChaosList instance) {
    this(fluent, instance, false);
  }
  public BlockChaosListBuilder(BlockChaosListFluent<?> fluent,BlockChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BlockChaosListBuilder(BlockChaosList instance) {
    this(instance,false);
  }
  public BlockChaosListBuilder(BlockChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  BlockChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public BlockChaosList build() {
    BlockChaosList buildable = new BlockChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}