package io.fabric8.chaosmesh.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChaosmeshSchemaBuilder extends ChaosmeshSchemaFluentImpl<ChaosmeshSchemaBuilder> implements VisitableBuilder<ChaosmeshSchema,ChaosmeshSchemaBuilder>{
  public ChaosmeshSchemaBuilder() {
    this(false);
  }
  public ChaosmeshSchemaBuilder(Boolean validationEnabled) {
    this(new ChaosmeshSchema(), validationEnabled);
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChaosmeshSchema(), validationEnabled);
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,ChaosmeshSchema instance) {
    this(fluent, instance, false);
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchemaFluent<?> fluent,ChaosmeshSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1BlockDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockDelaySpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ChaosCondition(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ChaosCondition());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ClockSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ClockSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DiskFillSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DiskFillSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DiskPayloadSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DiskPayloadSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(instance.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Frame(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Frame());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosAction());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1IoFault(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMGCSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMGCSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMLatencySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMLatencySpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMRuleDataSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMRuleDataSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1JVMStressSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMStressSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1MistakeSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MistakeSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkBandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkBandwidthSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkCorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkCorruptSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDNSSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDNSSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDelaySpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDuplicateSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkLossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkLossSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkPartitionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkPartitionSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineSelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineSelectorSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosActions());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchActions());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchBodyAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchBodyAction());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosReplaceActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosReplaceActions());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosRule(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosRule());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSelector(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSelector());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodSelector(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelector());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1PodSelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelectorSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ProcessSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ProcessSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Record(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Record());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressCPUSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressCPUSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1StressMemorySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressMemorySpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Stressors(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus());
      fluent.withGithubComChaosMeshChaosMeshApiV1alpha1Timespec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchema instance) {
    this(instance,false);
  }
  public ChaosmeshSchemaBuilder(ChaosmeshSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1BlockDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1BlockDelaySpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1ChaosCondition(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ChaosCondition());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1ClockSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ClockSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DiskFillSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DiskFillSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DiskPayloadSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DiskPayloadSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(instance.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1Frame(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Frame());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosAction());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IOChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1IoFault(instance.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMGCSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMGCSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMLatencySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMLatencySpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMRuleDataSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMRuleDataSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1JVMStressSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1JVMStressSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1MistakeSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1MistakeSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkBandwidthSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkBandwidthSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkCorruptSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkCorruptSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDNSSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDNSSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDelaySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDelaySpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkDuplicateSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDuplicateSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkLossSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkLossSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1NetworkPartitionSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkPartitionSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineSelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineSelectorSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosActions());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchActions());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchBodyAction(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchBodyAction());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosReplaceActions(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosReplaceActions());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosRule(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosRule());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSelector(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSelector());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodSelector(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelector());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1PodSelectorSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelectorSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1ProcessSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ProcessSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(instance.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1Record(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Record());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressCPUSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressCPUSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1StressMemorySpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1StressMemorySpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1Stressors(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(instance.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus());
      this.withGithubComChaosMeshChaosMeshApiV1alpha1Timespec(instance.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChaosmeshSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public ChaosmeshSchema build() {
    ChaosmeshSchema buildable = new ChaosmeshSchema(fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AWSChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1AttrOverrideSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BandwidthSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BlockChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1BlockDelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1CPUStressor(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ChaosCondition(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ClockSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1CorruptSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DNSChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DiskFillSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DiskPayloadSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1DuplicateSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ExperimentStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1FailKernRequest(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Frame(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1GCPChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1HTTPChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosAction(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IOChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1IoFault(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMExceptionSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMGCSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMLatencySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMReturnSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMRuleDataSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1JVMStressSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1KernelChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1LossSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1MemoryStressor(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1MistakeSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkBandwidthSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkCorruptSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDNSSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDelaySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkDuplicateSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkLossSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1NetworkPartitionSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PhysicalMachineSelectorSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosActions(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchActions(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosPatchBodyAction(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosReplaceActions(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosRule(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSelector(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodHttpChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodIOChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodNetworkChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelector(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1PodSelectorSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ProcessSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawIPSet(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawIptables(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1RawTrafficControl(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Record(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1ReorderSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressCPUSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressInstance(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1StressMemorySpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Stressors(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaos(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosList(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosSpec(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1TimeChaosStatus(),fluent.getGithubComChaosMeshChaosMeshApiV1alpha1Timespec());
    return buildable;
  }
  
}