/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.CertificateDNSNameSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateDNSNameSelectorFluent<A extends CertificateDNSNameSelectorFluent<A>>
extends BaseFluent<A> {
    private List<String> dnsNames = new ArrayList<String>();
    private List<String> dnsZones = new ArrayList<String>();
    private Map<String, String> matchLabels;

    public CertificateDNSNameSelectorFluent() {
    }

    public CertificateDNSNameSelectorFluent(CertificateDNSNameSelector instance) {
        CertificateDNSNameSelector certificateDNSNameSelector = instance = instance != null ? instance : new CertificateDNSNameSelector();
        if (instance != null) {
            this.withDnsNames(instance.getDnsNames());
            this.withDnsZones(instance.getDnsZones());
            this.withMatchLabels(instance.getMatchLabels());
            this.withDnsNames(instance.getDnsNames());
            this.withDnsZones(instance.getDnsZones());
            this.withMatchLabels(instance.getMatchLabels());
        }
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)((Object)this);
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public A addToDnsZones(int index, String item) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        this.dnsZones.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsZones(int index, String item) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        this.dnsZones.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsZones(String ... items) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsZones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsZones(Collection<String> items) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsZones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsZones(String ... items) {
        if (this.dnsZones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsZones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsZones(Collection<String> items) {
        if (this.dnsZones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsZones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsZones() {
        return this.dnsZones;
    }

    public String getDnsZone(int index) {
        return this.dnsZones.get(index);
    }

    public String getFirstDnsZone() {
        return this.dnsZones.get(0);
    }

    public String getLastDnsZone() {
        return this.dnsZones.get(this.dnsZones.size() - 1);
    }

    public String getMatchingDnsZone(Predicate<String> predicate) {
        for (String item : this.dnsZones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsZone(Predicate<String> predicate) {
        for (String item : this.dnsZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsZones(List<String> dnsZones) {
        if (dnsZones != null) {
            this.dnsZones = new ArrayList<String>();
            for (String item : dnsZones) {
                this.addToDnsZones(item);
            }
        } else {
            this.dnsZones = null;
        }
        return (A)((Object)this);
    }

    public A withDnsZones(String ... dnsZones) {
        if (this.dnsZones != null) {
            this.dnsZones.clear();
            this._visitables.remove((Object)"dnsZones");
        }
        if (dnsZones != null) {
            for (String item : dnsZones) {
                this.addToDnsZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsZones() {
        return this.dnsZones != null && !this.dnsZones.isEmpty();
    }

    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)((Object)this);
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateDNSNameSelectorFluent that = (CertificateDNSNameSelectorFluent)((Object)o);
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.dnsZones, that.dnsZones)) {
            return false;
        }
        return Objects.equals(this.matchLabels, that.matchLabels);
    }

    public int hashCode() {
        return Objects.hash(this.dnsNames, this.dnsZones, this.matchLabels, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.dnsZones != null && !this.dnsZones.isEmpty()) {
            sb.append("dnsZones:");
            sb.append(this.dnsZones + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }
}

