package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JKSKeystoreBuilder extends JKSKeystoreFluentImpl<JKSKeystoreBuilder> implements VisitableBuilder<JKSKeystore,JKSKeystoreBuilder>{
  public JKSKeystoreBuilder() {
    this(false);
  }
  public JKSKeystoreBuilder(Boolean validationEnabled) {
    this(new JKSKeystore(), validationEnabled);
  }
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent) {
    this(fluent, false);
  }
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JKSKeystore(), validationEnabled);
  }
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent,JKSKeystore instance) {
    this(fluent, instance, false);
  }
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent,JKSKeystore instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCreate(instance.getCreate());
      fluent.withPasswordSecretRef(instance.getPasswordSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JKSKeystoreBuilder(JKSKeystore instance) {
    this(instance,false);
  }
  public JKSKeystoreBuilder(JKSKeystore instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCreate(instance.getCreate());
      this.withPasswordSecretRef(instance.getPasswordSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  JKSKeystoreFluent<?> fluent;
  Boolean validationEnabled;
  public JKSKeystore build() {
    JKSKeystore buildable = new JKSKeystore(fluent.getCreate(),fluent.getPasswordSecretRef());
    return buildable;
  }
  
}