package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerConditionBuilder extends IssuerConditionFluentImpl<IssuerConditionBuilder> implements VisitableBuilder<IssuerCondition,IssuerConditionBuilder>{
  public IssuerConditionBuilder() {
    this(false);
  }
  public IssuerConditionBuilder(Boolean validationEnabled) {
    this(new IssuerCondition(), validationEnabled);
  }
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IssuerCondition(), validationEnabled);
  }
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent,IssuerCondition instance) {
    this(fluent, instance, false);
  }
  public IssuerConditionBuilder(IssuerConditionFluent<?> fluent,IssuerCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IssuerConditionBuilder(IssuerCondition instance) {
    this(instance,false);
  }
  public IssuerConditionBuilder(IssuerCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  IssuerConditionFluent<?> fluent;
  Boolean validationEnabled;
  public IssuerCondition build() {
    IssuerCondition buildable = new IssuerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}