package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateRequestStatusFluentImpl<A extends CertificateRequestStatusFluent<A>> extends BaseFluent<A> implements CertificateRequestStatusFluent<A>{
  public CertificateRequestStatusFluentImpl() {
  }
  public CertificateRequestStatusFluentImpl(CertificateRequestStatus instance) {
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withCertificate(instance.getCertificate());
      this.withConditions(instance.getConditions());
      this.withFailureTime(instance.getFailureTime());
    }
  }
  private String ca;
  private String certificate;
  private ArrayList<CertificateRequestConditionBuilder> conditions = new ArrayList<CertificateRequestConditionBuilder>();
  private String failureTime;
  public String getCa() {
    return this.ca;
  }
  public A withCa(String ca) {
    this.ca=ca; return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public String getCertificate() {
    return this.certificate;
  }
  public A withCertificate(String certificate) {
    this.certificate=certificate; return (A) this;
  }
  public Boolean hasCertificate() {
    return this.certificate != null;
  }
  public A addToConditions(int index,CertificateRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateRequestConditionBuilder>();}
    CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,CertificateRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateRequestConditionBuilder>();}
    CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateRequestCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateRequestConditionBuilder>();}
    for (CertificateRequestCondition item : items) {CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<CertificateRequestCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateRequestConditionBuilder>();}
    for (CertificateRequestCondition item : items) {CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateRequestCondition... items) {
    for (CertificateRequestCondition item : items) {CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<CertificateRequestCondition> items) {
    for (CertificateRequestCondition item : items) {CertificateRequestConditionBuilder builder = new CertificateRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<CertificateRequestConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<CertificateRequestConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      CertificateRequestConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateRequestCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<CertificateRequestCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public CertificateRequestCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public CertificateRequestCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public CertificateRequestCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public CertificateRequestCondition buildMatchingCondition(Predicate<CertificateRequestConditionBuilder> predicate) {
    for (CertificateRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<CertificateRequestConditionBuilder> predicate) {
    for (CertificateRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<CertificateRequestCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (CertificateRequestCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateRequestCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (CertificateRequestCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new CertificateRequestCondition(lastTransitionTime, message, reason, status, type));
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new CertificateRequestStatusFluentImpl.ConditionsNestedImpl();
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> addNewConditionLike(CertificateRequestCondition item) {
    return new CertificateRequestStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,CertificateRequestCondition item) {
    return new CertificateRequestStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateRequestStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<CertificateRequestConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getFailureTime() {
    return this.failureTime;
  }
  public A withFailureTime(String failureTime) {
    this.failureTime=failureTime; return (A) this;
  }
  public Boolean hasFailureTime() {
    return this.failureTime != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateRequestStatusFluentImpl that = (CertificateRequestStatusFluentImpl) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;

    if (!java.util.Objects.equals(certificate, that.certificate)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(failureTime, that.failureTime)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  certificate,  conditions,  failureTime,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (failureTime != null) { sb.append("failureTime:"); sb.append(failureTime); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends CertificateRequestConditionFluentImpl<CertificateRequestStatusFluentImpl.ConditionsNested<N>> implements CertificateRequestStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,CertificateRequestCondition item) {
      this.index = index;
      this.builder = new CertificateRequestConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new CertificateRequestConditionBuilder(this);
    }
    CertificateRequestConditionBuilder builder;
    int index;
    public N and() {
      return (N) CertificateRequestStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}