package io.fabric8.certmanager.api.model.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateRequestSpecFluentImpl<A extends CertificateRequestSpecFluent<A>> extends BaseFluent<A> implements CertificateRequestSpecFluent<A>{
  public CertificateRequestSpecFluentImpl() {
  }
  public CertificateRequestSpecFluentImpl(CertificateRequestSpec instance) {
    if (instance != null) {
      this.withDuration(instance.getDuration());
      this.withIsCA(instance.getIsCA());
      this.withIssuerRef(instance.getIssuerRef());
      this.withRequest(instance.getRequest());
      this.withUsages(instance.getUsages());
    }
  }
  private Duration duration;
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String request;
  private List<String> usages;
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public Boolean hasIsCA() {
    return this.isCA != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public CertificateRequestSpecFluentImpl.IssuerRefNested<A> withNewIssuerRef() {
    return new CertificateRequestSpecFluentImpl.IssuerRefNestedImpl();
  }
  public CertificateRequestSpecFluentImpl.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new CertificateRequestSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public CertificateRequestSpecFluentImpl.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public CertificateRequestSpecFluentImpl.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public CertificateRequestSpecFluentImpl.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  public String getRequest() {
    return this.request;
  }
  public A withRequest(String request) {
    this.request=request; return (A) this;
  }
  public Boolean hasRequest() {
    return this.request != null;
  }
  public A addToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(int index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear(); _visitables.remove("usages"); }
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl) o;
    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(isCA, that.isCA)) return false;

    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;

    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(usages, that.usages)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(duration,  isCA,  issuerRef,  request,  usages,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<CertificateRequestSpecFluentImpl.IssuerRefNested<N>> implements CertificateRequestSpecFluentImpl.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateRequestSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  
}