package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OrderStatusBuilder extends OrderStatusFluentImpl<OrderStatusBuilder> implements VisitableBuilder<OrderStatus,OrderStatusBuilder>{
  public OrderStatusBuilder() {
    this(false);
  }
  public OrderStatusBuilder(Boolean validationEnabled) {
    this(new OrderStatus(), validationEnabled);
  }
  public OrderStatusBuilder(OrderStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OrderStatusBuilder(OrderStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OrderStatus(), validationEnabled);
  }
  public OrderStatusBuilder(OrderStatusFluent<?> fluent,OrderStatus instance) {
    this(fluent, instance, false);
  }
  public OrderStatusBuilder(OrderStatusFluent<?> fluent,OrderStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthorizations(instance.getAuthorizations());
      fluent.withCertificate(instance.getCertificate());
      fluent.withFailureTime(instance.getFailureTime());
      fluent.withFinalizeURL(instance.getFinalizeURL());
      fluent.withReason(instance.getReason());
      fluent.withState(instance.getState());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OrderStatusBuilder(OrderStatus instance) {
    this(instance,false);
  }
  public OrderStatusBuilder(OrderStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthorizations(instance.getAuthorizations());
      this.withCertificate(instance.getCertificate());
      this.withFailureTime(instance.getFailureTime());
      this.withFinalizeURL(instance.getFinalizeURL());
      this.withReason(instance.getReason());
      this.withState(instance.getState());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  OrderStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OrderStatus build() {
    OrderStatus buildable = new OrderStatus(fluent.getAuthorizations(),fluent.getCertificate(),fluent.getFailureTime(),fluent.getFinalizeURL(),fluent.getReason(),fluent.getState(),fluent.getUrl());
    return buildable;
  }
  
}