package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEChallengeSolverHTTP01IngressBuilder extends ACMEChallengeSolverHTTP01IngressFluentImpl<ACMEChallengeSolverHTTP01IngressBuilder> implements VisitableBuilder<ACMEChallengeSolverHTTP01Ingress,ACMEChallengeSolverHTTP01IngressBuilder>{
  public ACMEChallengeSolverHTTP01IngressBuilder() {
    this(false);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(Boolean validationEnabled) {
    this(new ACMEChallengeSolverHTTP01Ingress(), validationEnabled);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01IngressFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01IngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEChallengeSolverHTTP01Ingress(), validationEnabled);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01IngressFluent<?> fluent,ACMEChallengeSolverHTTP01Ingress instance) {
    this(fluent, instance, false);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01IngressFluent<?> fluent,ACMEChallengeSolverHTTP01Ingress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withIngressTemplate(instance.getIngressTemplate());
      fluent.withName(instance.getName());
      fluent.withPodTemplate(instance.getPodTemplate());
      fluent.withServiceType(instance.getServiceType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01Ingress instance) {
    this(instance,false);
  }
  public ACMEChallengeSolverHTTP01IngressBuilder(ACMEChallengeSolverHTTP01Ingress instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withIngressTemplate(instance.getIngressTemplate());
      this.withName(instance.getName());
      this.withPodTemplate(instance.getPodTemplate());
      this.withServiceType(instance.getServiceType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEChallengeSolverHTTP01IngressFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEChallengeSolverHTTP01Ingress build() {
    ACMEChallengeSolverHTTP01Ingress buildable = new ACMEChallengeSolverHTTP01Ingress(fluent.getClassName(),fluent.getIngressTemplate(),fluent.getName(),fluent.getPodTemplate(),fluent.getServiceType());
    return buildable;
  }
  
}