package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluentImpl<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(false);
  }
  public CertmanagerSchemaBuilder(Boolean validationEnabled) {
    this(new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this(fluent, instance, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Order());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this(instance,false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Order());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject());
      this.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertmanagerSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1Order(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec(),fluent.getGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP(),fluent.getGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  
}