package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateStatusFluentImpl<A extends CertificateStatusFluent<A>> extends BaseFluent<A> implements CertificateStatusFluent<A>{
  public CertificateStatusFluentImpl() {
  }
  public CertificateStatusFluentImpl(CertificateStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withLastFailureTime(instance.getLastFailureTime()); 
    this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName()); 
    this.withNotAfter(instance.getNotAfter()); 
    this.withNotBefore(instance.getNotBefore()); 
    this.withRenewalTime(instance.getRenewalTime()); 
    this.withRevision(instance.getRevision()); 
  }
  private ArrayList<CertificateConditionBuilder> conditions = new ArrayList<CertificateConditionBuilder>();
  private String lastFailureTime;
  private String nextPrivateKeySecretName;
  private String notAfter;
  private String notBefore;
  private String renewalTime;
  private Integer revision;
  public A addToConditions(Integer index,CertificateCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,CertificateCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    CertificateConditionBuilder builder = new CertificateConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<CertificateCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateConditionBuilder>();}
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateCondition... items) {
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<CertificateCondition> items) {
    for (CertificateCondition item : items) {CertificateConditionBuilder builder = new CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<CertificateConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<CertificateConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      CertificateConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<CertificateCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public CertificateCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public CertificateCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public CertificateCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public CertificateCondition buildMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    for (CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    for (CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<CertificateCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (CertificateCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.certmanager.api.model.v1beta1.CertificateCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (CertificateCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public CertificateStatusFluent.ConditionsNested<A> addNewCondition() {
    return new CertificateStatusFluentImpl.ConditionsNestedImpl();
  }
  public CertificateStatusFluent.ConditionsNested<A> addNewConditionLike(CertificateCondition item) {
    return new CertificateStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public CertificateStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,CertificateCondition item) {
    return new CertificateStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public CertificateStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public CertificateStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<CertificateConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getLastFailureTime() {
    return this.lastFailureTime;
  }
  public A withLastFailureTime(String lastFailureTime) {
    this.lastFailureTime=lastFailureTime; return (A) this;
  }
  public Boolean hasLastFailureTime() {
    return this.lastFailureTime != null;
  }
  public String getNextPrivateKeySecretName() {
    return this.nextPrivateKeySecretName;
  }
  public A withNextPrivateKeySecretName(String nextPrivateKeySecretName) {
    this.nextPrivateKeySecretName=nextPrivateKeySecretName; return (A) this;
  }
  public Boolean hasNextPrivateKeySecretName() {
    return this.nextPrivateKeySecretName != null;
  }
  public String getNotAfter() {
    return this.notAfter;
  }
  public A withNotAfter(String notAfter) {
    this.notAfter=notAfter; return (A) this;
  }
  public Boolean hasNotAfter() {
    return this.notAfter != null;
  }
  public String getNotBefore() {
    return this.notBefore;
  }
  public A withNotBefore(String notBefore) {
    this.notBefore=notBefore; return (A) this;
  }
  public Boolean hasNotBefore() {
    return this.notBefore != null;
  }
  public String getRenewalTime() {
    return this.renewalTime;
  }
  public A withRenewalTime(String renewalTime) {
    this.renewalTime=renewalTime; return (A) this;
  }
  public Boolean hasRenewalTime() {
    return this.renewalTime != null;
  }
  public Integer getRevision() {
    return this.revision;
  }
  public A withRevision(Integer revision) {
    this.revision=revision; return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateStatusFluentImpl that = (CertificateStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (lastFailureTime != null ? !lastFailureTime.equals(that.lastFailureTime) :that.lastFailureTime != null) return false;
    if (nextPrivateKeySecretName != null ? !nextPrivateKeySecretName.equals(that.nextPrivateKeySecretName) :that.nextPrivateKeySecretName != null) return false;
    if (notAfter != null ? !notAfter.equals(that.notAfter) :that.notAfter != null) return false;
    if (notBefore != null ? !notBefore.equals(that.notBefore) :that.notBefore != null) return false;
    if (renewalTime != null ? !renewalTime.equals(that.renewalTime) :that.renewalTime != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastFailureTime,  nextPrivateKeySecretName,  notAfter,  notBefore,  renewalTime,  revision,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastFailureTime != null) { sb.append("lastFailureTime:"); sb.append(lastFailureTime + ","); }
    if (nextPrivateKeySecretName != null) { sb.append("nextPrivateKeySecretName:"); sb.append(nextPrivateKeySecretName + ","); }
    if (notAfter != null) { sb.append("notAfter:"); sb.append(notAfter + ","); }
    if (notBefore != null) { sb.append("notBefore:"); sb.append(notBefore + ","); }
    if (renewalTime != null) { sb.append("renewalTime:"); sb.append(renewalTime + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends CertificateConditionFluentImpl<CertificateStatusFluent.ConditionsNested<N>> implements CertificateStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,CertificateCondition item) {
      this.index = index;
      this.builder = new CertificateConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new CertificateConditionBuilder(this);
    }
    CertificateConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) CertificateStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}