package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestConditionBuilder extends CertificateRequestConditionFluentImpl<CertificateRequestConditionBuilder> implements VisitableBuilder<CertificateRequestCondition,CertificateRequestConditionBuilder>{
  public CertificateRequestConditionBuilder() {
    this(false);
  }
  public CertificateRequestConditionBuilder(Boolean validationEnabled) {
    this(new CertificateRequestCondition(), validationEnabled);
  }
  public CertificateRequestConditionBuilder(CertificateRequestConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestConditionBuilder(CertificateRequestConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateRequestCondition(), validationEnabled);
  }
  public CertificateRequestConditionBuilder(CertificateRequestConditionFluent<?> fluent,CertificateRequestCondition instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestConditionBuilder(CertificateRequestConditionFluent<?> fluent,CertificateRequestCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestConditionBuilder(CertificateRequestCondition instance) {
    this(instance,false);
  }
  public CertificateRequestConditionBuilder(CertificateRequestCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateRequestConditionFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateRequestCondition build() {
    CertificateRequestCondition buildable = new CertificateRequestCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}