package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEChallengeSolverDNS01Builder extends ACMEChallengeSolverDNS01FluentImpl<ACMEChallengeSolverDNS01Builder> implements VisitableBuilder<ACMEChallengeSolverDNS01,ACMEChallengeSolverDNS01Builder>{
  public ACMEChallengeSolverDNS01Builder() {
    this(false);
  }
  public ACMEChallengeSolverDNS01Builder(Boolean validationEnabled) {
    this(new ACMEChallengeSolverDNS01(), validationEnabled);
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01Fluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEChallengeSolverDNS01(), validationEnabled);
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01Fluent<?> fluent,ACMEChallengeSolverDNS01 instance) {
    this(fluent, instance, false);
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01Fluent<?> fluent,ACMEChallengeSolverDNS01 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAcmeDNS(instance.getAcmeDNS()); 
    fluent.withAkamai(instance.getAkamai()); 
    fluent.withAzureDNS(instance.getAzureDNS()); 
    fluent.withCloudDNS(instance.getCloudDNS()); 
    fluent.withCloudflare(instance.getCloudflare()); 
    fluent.withCnameStrategy(instance.getCnameStrategy()); 
    fluent.withDigitalocean(instance.getDigitalocean()); 
    fluent.withRfc2136(instance.getRfc2136()); 
    fluent.withRoute53(instance.getRoute53()); 
    fluent.withWebhook(instance.getWebhook()); 
    this.validationEnabled = validationEnabled; 
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01 instance) {
    this(instance,false);
  }
  public ACMEChallengeSolverDNS01Builder(ACMEChallengeSolverDNS01 instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAcmeDNS(instance.getAcmeDNS()); 
    this.withAkamai(instance.getAkamai()); 
    this.withAzureDNS(instance.getAzureDNS()); 
    this.withCloudDNS(instance.getCloudDNS()); 
    this.withCloudflare(instance.getCloudflare()); 
    this.withCnameStrategy(instance.getCnameStrategy()); 
    this.withDigitalocean(instance.getDigitalocean()); 
    this.withRfc2136(instance.getRfc2136()); 
    this.withRoute53(instance.getRoute53()); 
    this.withWebhook(instance.getWebhook()); 
    this.validationEnabled = validationEnabled; 
  }
  ACMEChallengeSolverDNS01Fluent<?> fluent;
  Boolean validationEnabled;
  public ACMEChallengeSolverDNS01 build() {
    ACMEChallengeSolverDNS01 buildable = new ACMEChallengeSolverDNS01(fluent.getAcmeDNS(),fluent.getAkamai(),fluent.getAzureDNS(),fluent.getCloudDNS(),fluent.getCloudflare(),fluent.getCnameStrategy(),fluent.getDigitalocean(),fluent.getRfc2136(),fluent.getRoute53(),fluent.getWebhook());
    return buildable;
  }
  
}