package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateRequestSpecFluentImpl<A extends CertificateRequestSpecFluent<A>> extends BaseFluent<A> implements CertificateRequestSpecFluent<A>{
  public CertificateRequestSpecFluentImpl() {
  }
  public CertificateRequestSpecFluentImpl(CertificateRequestSpec instance) {
    this.withCsr(instance.getCsr()); 
    this.withDuration(instance.getDuration()); 
    this.withExtra(instance.getExtra()); 
    this.withGroups(instance.getGroups()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withUid(instance.getUid()); 
    this.withUsages(instance.getUsages()); 
    this.withUsername(instance.getUsername()); 
  }
  private String csr;
  private Duration duration;
  private Map<String,List<String>> extra;
  private List<String> groups = new ArrayList<String>();
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String uid;
  private List<String> usages = new ArrayList<String>();
  private String username;
  public String getCsr() {
    return this.csr;
  }
  public A withCsr(String csr) {
    this.csr=csr; return (A) this;
  }
  public Boolean hasCsr() {
    return this.csr != null;
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToExtra(String key,List<String> value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  public A addToExtra(Map<String,List<String>> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  public A removeFromExtra(Map<String,List<String>> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  public Map<String,List<String>> getExtra() {
    return this.extra;
  }
  public <K,V>A withExtra(Map<String,List<String>> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap(extra);} return (A) this;
  }
  public Boolean hasExtra() {
    return this.extra != null;
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public Boolean hasIsCA() {
    return this.isCA != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
    return new CertificateRequestSpecFluentImpl.IssuerRefNestedImpl();
  }
  public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new CertificateRequestSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public A addToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(Integer index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear();}
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl) o;
    if (csr != null ? !csr.equals(that.csr) :that.csr != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (isCA != null ? !isCA.equals(that.isCA) :that.isCA != null) return false;
    if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
    if (username != null ? !username.equals(that.username) :that.username != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(csr,  duration,  extra,  groups,  isCA,  issuerRef,  uid,  usages,  username,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (csr != null) { sb.append("csr:"); sb.append(csr + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages + ","); }
    if (username != null) { sb.append("username:"); sb.append(username); }
    sb.append("}");
    return sb.toString();
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<CertificateRequestSpecFluent.IssuerRefNested<N>> implements CertificateRequestSpecFluent.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateRequestSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  
}