package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureManagedIdentityBuilder extends AzureManagedIdentityFluentImpl<AzureManagedIdentityBuilder> implements VisitableBuilder<AzureManagedIdentity,AzureManagedIdentityBuilder>{
  public AzureManagedIdentityBuilder() {
    this(false);
  }
  public AzureManagedIdentityBuilder(Boolean validationEnabled) {
    this(new AzureManagedIdentity(), validationEnabled);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureManagedIdentity(), validationEnabled);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,AzureManagedIdentity instance) {
    this(fluent, instance, false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,AzureManagedIdentity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientID(instance.getClientID()); 
    fluent.withResourceID(instance.getResourceID()); 
    this.validationEnabled = validationEnabled; 
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentity instance) {
    this(instance,false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentity instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientID(instance.getClientID()); 
    this.withResourceID(instance.getResourceID()); 
    this.validationEnabled = validationEnabled; 
  }
  AzureManagedIdentityFluent<?> fluent;
  Boolean validationEnabled;
  public AzureManagedIdentity build() {
    AzureManagedIdentity buildable = new AzureManagedIdentity(fluent.getClientID(),fluent.getResourceID());
    return buildable;
  }
  
}